<?php
require_once 'includes/db_config.php';

header('Content-Type: application/json');

$response = ['status' => 'error', 'message' => 'Invalid request.'];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['id'])) {
    $announcement_id = intval($_POST['id']);

    if ($announcement_id > 0) {
        $sql = "UPDATE announcements SET views_count = views_count + 1 WHERE id = ?";
        if ($stmt = mysqli_prepare($link, $sql)) {
            mysqli_stmt_bind_param($stmt, "i", $announcement_id);
            if (mysqli_stmt_execute($stmt)) {
                $response['status'] = 'success';
                
                // Fetch the new view count to send back
                $sql_select = "SELECT views_count FROM announcements WHERE id = ?";
                if ($stmt_select = mysqli_prepare($link, $sql_select)) {
                    mysqli_stmt_bind_param($stmt_select, "i", $announcement_id);
                    mysqli_stmt_execute($stmt_select);
                    $result_select = mysqli_stmt_get_result($stmt_select);
                    $row = mysqli_fetch_assoc($result_select);
                    $response['new_count'] = $row['views_count'];
                    mysqli_stmt_close($stmt_select);
                }
            } else {
                $response['message'] = 'Database update failed.';
            }
            mysqli_stmt_close($stmt);
        } else {
            $response['message'] = 'Database statement preparation failed.';
        }
    } else {
        $response['message'] = 'Invalid announcement ID.';
    }
}

echo json_encode($response);
?>