<?php
// includes/header.php
require_once 'includes/db_config.php';
require_once 'includes/functions.php';

// Get system settings
$system_name = get_setting('system_name', $link) ?? 'Club Portal';
$system_logo = get_setting('system_logo', $link) ?? 'assets/images/default_logo.png';
$header_text = get_setting('header_text', $link) ?? 'Club Management Portal';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($system_name); ?> - Portal</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <!-- Custom stylesheet -->
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        /* Sidebar styling */
        .sidebar {
            position: fixed;
            top: 56px; /* Match navbar height */
            bottom: 0;
            left: 0;
            width: 250px;
            z-index: 100;
            overflow-y: auto;
            transition: transform 0.3s ease-in-out;
            background-color: #343a40; /* Match bg-dark */
        }
        .sidebar.collapsed {
            transform: translateX(-100%);
        }
        .main-content {
            margin-left: 250px;
            padding: 20px;
            padding-top: 80px; /* Increased to clear navbar (56px) + extra padding */
            transition: margin-left 0.3s ease-in-out;
            min-height: calc(100vh - 56px); /* Ensure content fills viewport minus navbar */
        }
        .sidebar-collapsed .main-content {
            margin-left: 0;
        }
        @media (max-width: 767.98px) {
            .sidebar {
                transform: translateX(-100%);
            }
            .sidebar:not(.collapsed) {
                transform: translateX(0);
            }
            .main-content {
                margin-left: 0;
                padding-top: 80px; /* Maintain padding for navbar on mobile */
            }
        }
        /* Navbar logout button styling */
        .logout-btn {
            background-color: #dc3545;
            border-radius: 8px;
            padding: 8px 16px;
            font-size: 1rem;
            transition: background-color 0.3s;
            color: #fff;
            text-decoration: none;
        }
        .logout-btn:hover {
            background-color: #c82333;
            color: #fff;
        }
        @media (max-width: 767.98px) {
            .logout-btn {
                padding: 6px 12px;
                font-size: 0.9rem;
            }
        }
        /* Orange dropdown styling */
        .dropdown-menu-end {
            background-color: #f59e0b; /* Orange */
            border: none;
        }
        .dropdown-menu-end .dropdown-item {
            color: #1f2937; /* Navy blue text */
        }
        .dropdown-menu-end .dropdown-item:hover,
        .dropdown-menu-end .dropdown-item:focus {
            background-color: #d97706; /* Darker orange on hover */
            color: #1f2937; /* Navy blue text */
        }
        .dropdown-menu-end .dropdown-divider {
            border-top: 1px solid #d97706; /* Darker orange divider */
            opacity: 0.5;
        }
    </style>
</head>
<body class="d-flex flex-column min-vh-100">
    <!-- Top Navigation Bar -->
    <nav class="navbar navbar-expand-md navbar-dark bg-dark fixed-top">
        <div class="container-fluid">
            <!-- Sidebar toggle button -->
            <button class="btn btn-dark me-2" type="button" id="sidebarToggle" aria-label="Toggle sidebar">
                <i class="fas fa-bars"></i>
            </button>
            <a class="navbar-brand me-auto" href="member_dashboard.php">
                <img src="<?php echo htmlspecialchars($system_logo); ?>" alt="Club Logo" class="logo-img me-2" style="width: 40px; height: 40px;">
                <?php echo htmlspecialchars($header_text); ?>
            </a>
            <?php if (is_logged_in()): ?>
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle logout-btn" href="#" id="userDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fas fa-user me-2"></i><?php echo htmlspecialchars($_SESSION['user_name'] ?? 'User'); ?>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
                            <li><a class="dropdown-item" href="profile.php">Profile</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="logout.php"><i class="fas fa-sign-out-alt me-2"></i>Logout</a></li>
                        </ul>
                    </li>
                </ul>
            <?php endif; ?>
        </div>
    </nav>
    <?php include_global_scripts(); ?>
    
    <br><br><br>