<?php
// includes/footer.php
require_once 'includes/db_config.php';
require_once 'includes/functions.php';

$footer_text = get_setting('footer_text', $link);
if (!$footer_text) {
    $footer_text = '&copy; ' . date('Y') . ' Agbon Club. All Rights Reserved.';
}
?>

<footer class="bg-dark text-white text-center py-3 mt-auto">
    <p class="mb-0">
        <?php echo htmlspecialchars($footer_text); ?>
        Powered by <a href="https://mtclive.com.ng" style="color: #fff; text-decoration: none;">Multitask</a>
    </p>
</footer>

<!-- Bootstrap JS Bundle -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
<script src="assets/js/scripts.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function () {
    // Sidebar toggle
    const sidebar = document.querySelector('#sidebarMenu');
    const toggleButton = document.querySelector('#sidebarToggle');
    const body = document.body;
    const mainContent = document.querySelector('.main-content');

    if (sidebar && toggleButton && mainContent) {
        // Initially collapse sidebar on mobile
        if (window.innerWidth < 768) {
            sidebar.classList.add('collapsed');
            body.classList.add('sidebar-collapsed');
        }

        toggleButton.addEventListener('click', function () {
            sidebar.classList.toggle('collapsed');
            body.classList.toggle('sidebar-collapsed');
        });
    }

    // Initialize all dropdowns with proper Bootstrap configuration
    const dropdownElements = document.querySelectorAll('.dropdown-toggle');
    dropdownElements.forEach(dropdown => {
        new bootstrap.Dropdown(dropdown, {
            popperConfig: {
                strategy: 'fixed' // Ensure dropdowns work in fixed sidebar
            }
        });
    });
});
</script>
</body>
</html>