<?php
session_start();
require_once 'includes/functions.php';
require_once 'includes/db_config.php';
require_once 'includes/financial_queries.php';
require_once 'includes/financial_utils.php';

// Enable error reporting for development (remove in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Check database connection
if (!$link) {
    die("ERROR: Could not connect. " . mysqli_connect_error());
}

// Check if user is logged in
if (!is_logged_in()) {
    redirect("login.php");
}

$is_admin = is_admin();
$system_name = get_setting('system_name', $link) ?? 'Club Portal'; // For dynamic title in template
$currency_symbol = get_setting('currency_symbol', $link) ?? '₦';

// Sanitize filter inputs
$valid_record_types = ['all', 'payments', 'expenses', 'debts', 'benefits'];
$valid_time_periods = ['all', 'date', 'week', 'month', 'year'];
$record_type = sanitize_filter($_GET['record_type'] ?? 'all', $valid_record_types, 'all');
$time_period = sanitize_filter($_GET['time_period'] ?? 'all', $valid_time_periods, 'all');
$filter_date = isset($_GET['filter_date']) && preg_match('/^\d{4}-\d{2}-\d{2}$/', $_GET['filter_date']) ? $_GET['filter_date'] : date('Y-m-d');
$search = isset($_GET['search']) ? trim(mysqli_real_escape_string($link, $_GET['search'])) : '';
$type_filter = isset($_GET['type_filter']) ? trim(mysqli_real_escape_string($link, $_GET['type_filter'])) : '';
$date_field = isset($_GET['date_field']) && $_GET['date_field'] === 'due_date' ? 'due_date' : 'created_at';

// Validate type filter
$type_filter_condition = validate_type_filter($type_filter, $record_type);

// Pagination settings
$tables = ['payments', 'expenses', 'debts', 'benefits'];
$pagination = [];
foreach ($tables as $table) {
    $pagination[$table] = [
        'per_page' => isset($_GET["per_page_$table"]) && in_array((int)$_GET["per_page_$table"], [5, 10, 25, 50, 100]) ? (int)$_GET["per_page_$table"] : 5,
        'page' => isset($_GET["page_$table"]) && is_numeric($_GET["page_$table"]) && $_GET["page_$table"] > 0 ? (int)$_GET["page_$table"] : 1
    ];
    $pagination[$table]['offset'] = ($pagination[$table]['page'] - 1) * $pagination[$table]['per_page'];
}

// Fetch data
$total_counts = get_total_counts($link, $record_type, $time_period, $filter_date, $type_filter, $search, $date_field, $pagination);
$total_pages = array_map(fn($table) => ceil($total_counts[$table] / $pagination[$table]['per_page']), $tables);

$total_payments = get_total_payments($link, $record_type, $time_period, $filter_date, $type_filter);
$total_expenses = get_total_expenses($link, $record_type, $time_period, $filter_date, $type_filter);
$total_benefits = get_total_benefits($link, $record_type, $time_period, $filter_date, $type_filter);
$total_debts = get_total_debts($link, $record_type, $time_period, $filter_date, $type_filter, $date_field);
$current_balance = $total_payments - $total_expenses - $total_benefits;

$total_members = get_total_members($link);
$total_payment_types = get_total_payment_types($link);
$prev_balances = get_previous_balances($link, $filter_date, $date_field);
$type_options = get_type_options($link);
$payments = get_payments($link, $record_type, $time_period, $filter_date, $type_filter, $search, $pagination['payments']);
$expenses = get_expenses($link, $record_type, $time_period, $filter_date, $type_filter, $search, $pagination['expenses']);
$benefits = get_benefits($link, $record_type, $time_period, $filter_date, $type_filter, $search, $pagination['benefits']);
$debts = get_debts($link, $record_type, $time_period, $filter_date, $type_filter, $search, $date_field, $pagination['debts']);
$payment_types_summary = get_payment_types_summary($link, $record_type, $time_period, $filter_date, $type_filter, $date_field);
$expense_types_summary = get_expense_types_summary($link, $record_type, $time_period, $filter_date, $type_filter);
$benefit_types_summary = get_benefit_types_summary($link, $record_type, $time_period, $filter_date, $type_filter);
$line_chart_data = get_line_chart_data($link, $filter_date, $date_field);

// Include the template after processing
require_once 'templates/financial_summary_template.php';
?>