<?php
require_once 'includes/functions.php';
require_once 'includes/db_config.php';

// Check if user is logged in and is an admin
if (!is_logged_in() || !is_admin()) {
    redirect("login.php");
}

$message = '';
$payment_data = null;
$members = [];

// Fetch all members for the dropdown
$sql_members = "SELECT id, full_name FROM users WHERE role = 'member' ORDER BY full_name ASC";
$result_members = mysqli_query($link, $sql_members);
if ($result_members) {
    while ($row = mysqli_fetch_assoc($result_members)) {
        $members[] = $row;
    }
}

// Handle form submission for updating payment
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['update_payment'])) {
    $payment_id = intval($_POST['payment_id']);
    $user_id = intval($_POST['user_id']);
    $amount = floatval($_POST['amount']);
    $payment_type = sanitize_input($_POST['payment_type']);
    $description = sanitize_input($_POST['description']);

    if ($payment_id && $user_id && $amount > 0) {
        $sql = "UPDATE payments SET user_id = ?, amount = ?, payment_type = ?, description = ? WHERE id = ?";
        if ($stmt = mysqli_prepare($link, $sql)) {
            mysqli_stmt_bind_param($stmt, "idssi", $user_id, $amount, $payment_type, $description, $payment_id);
            if (mysqli_stmt_execute($stmt)) {
                $message = "Payment updated successfully!";
            } else {
                $message = "Error updating payment: " . mysqli_error($link);
            }
            mysqli_stmt_close($stmt);
        }
    } else {
        $message = "Invalid input. Please check the form data.";
    }
}

// Fetch the payment data to pre-populate the form
if (isset($_GET['id']) && !empty($_GET['id'])) {
    $payment_id = intval($_GET['id']);
    $sql = "SELECT * FROM payments WHERE id = ?";
    if ($stmt = mysqli_prepare($link, $sql)) {
        mysqli_stmt_bind_param($stmt, "i", $payment_id);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);
        $payment_data = mysqli_fetch_assoc($result);
        mysqli_stmt_close($stmt);
    }
    if (!$payment_data) {
        $message = "Payment record not found.";
    }
} else if (!isset($_POST['update_payment'])) {
    redirect("payment_management.php?error=No payment specified for editing.");
}
?>

<?php require_once 'includes/header.php'; ?>
<div class="container-fluid">
    <div class="row">
        <?php require_once 'includes/sidebar.php'; ?>
        <main class="col-md-9 col-lg-10 main-content">
            <h2>Edit Payment Record</h2>

            <?php if ($message): ?>
                <div class="alert alert-<?php echo strpos($message, 'Error') !== false ? 'danger' : 'success'; ?>">
                    <?php echo $message; ?>
                </div>
            <?php endif; ?>

            <?php if ($payment_data): ?>
                <div class="card">
                    <div class="card-header">Update Payment</div>
                    <div class="card-body">
                        <form action="edit_payment.php" method="post">
                            <input type="hidden" name="update_payment" value="1">
                            <input type="hidden" name="payment_id" value="<?php echo htmlspecialchars($payment_data['id']); ?>">
                            
                            <div class="form-group">
                                <label for="user_id">Select Member</label>
                                <select name="user_id" id="user_id" class="form-control" required>
                                    <option value="">-- Select Member --</option>
                                    <?php foreach ($members as $member): ?>
                                        <option value="<?php echo $member['id']; ?>" <?php echo ($member['id'] == $payment_data['user_id']) ? 'selected' : ''; ?>>
                                            <?php echo htmlspecialchars($member['full_name']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="amount">Amount ($)</label>
                                <input type="number" name="amount" id="amount" class="form-control" step="0.01" min="0.01" value="<?php echo htmlspecialchars($payment_data['amount']); ?>" required>
                            </div>
                            <div class="form-group">
                                <label for="payment_type">Payment Type</label>
                                <select name="payment_type" id="payment_type" class="form-control" required>
                                    <option value="membership" <?php echo ($payment_data['payment_type'] == 'membership') ? 'selected' : ''; ?>>Membership Fee</option>
                                    <option value="donation" <?php echo ($payment_data['payment_type'] == 'donation') ? 'selected' : ''; ?>>Donation</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="description">Description</label>
                                <textarea name="description" id="description" class="form-control" rows="3"><?php echo htmlspecialchars($payment_data['description']); ?></textarea>
                            </div>
                            <button type="submit" class="btn btn-primary">Update Payment</button>
                            <a href="payment_management.php" class="btn btn-secondary">Cancel</a>
                        </form>
                    </div>
                </div>
            <?php endif; ?>
        </main>
    </div>
</div>
<?php require_once 'includes/footer.php'; ?>