<?php
// This API fetches detailed member financial data for the main table.
require_once '../includes/db_config.php';

// Set the content type to JSON
header('Content-Type: application/json');

// Get search and period filters from the request.
$search = isset($_GET['search']) ? $_GET['search'] : '';
$period = isset($_GET['period']) ? $_GET['period'] : 'all';

try {
    // Base SQL query to join users and payments tables
    $sql = "SELECT u.id AS member_id, u.full_name, u.membership_status, p.payment_type, p.amount AS amount_paid, p.status AS payment_status FROM users u LEFT JOIN payments p ON u.id = p.user_id WHERE 1=1";

    $params = [];
    $types = '';

    // Add search filter if provided
    if (!empty($search)) {
        // Updated to search by full_name, surname, and other_names for a more comprehensive result.
        $sql .= " AND (u.full_name LIKE ? OR u.surname LIKE ? OR u.other_names LIKE ?)";
        $search_term = "%" . $search . "%";
        $params[] = $search_term;
        $params[] = $search_term;
        $params[] = $search_term;
        $types .= 'sss';
    }

    // Add period filter if provided
    switch ($period) {
        case 'today':
            $sql .= " AND DATE(p.created_at) = CURRENT_DATE()";
            break;
        case 'this_week':
            $sql .= " AND YEARWEEK(p.created_at, 1) = YEARWEEK(CURRENT_DATE(), 1)";
            break;
        case 'this_month':
            $sql .= " AND MONTH(p.created_at) = MONTH(CURRENT_DATE()) AND YEAR(p.created_at) = YEAR(CURRENT_DATE())";
            break;
        case 'this_year':
            $sql .= " AND YEAR(p.created_at) = YEAR(CURRENT_DATE())";
            break;
    }
    
    // Order by the most recent payments
    $sql .= " ORDER BY p.created_at DESC";

    $stmt = $link->prepare($sql);
    if ($stmt === false) {
        throw new Exception("Prepare failed: " . $link->error);
    }

    // Bind parameters dynamically if any exist
    if (!empty($params)) {
        $stmt->bind_param($types, ...$params);
    }
    
    $stmt->execute();
    $result = $stmt->get_result();
    
    $members = [];
    while ($row = $result->fetch_assoc()) {
        $members[] = $row;
    }

    $response = [
        'success' => true,
        'members' => $members,
        'message' => empty($members) ? 'No financial data found.' : 'Financial data retrieved successfully.'
    ];

} catch (Exception $e) {
    $response = [
        'success' => false,
        'message' => 'Error fetching data: ' . $e->getMessage()
    ];
}

echo json_encode($response);
?>
