<?php
require_once '../includes/functions.php';
require_once '../includes/db_config.php';
session_start();

// Check if user is logged in and is admin
if (!is_logged_in() || !is_admin()) {
    http_response_code(403);
    exit('Access denied');
}

// Check database connection
if (!$link) {
    http_response_code(500);
    exit("ERROR: Could not connect. " . mysqli_connect_error());
}

// Filter settings
$record_type = isset($_GET['record_type']) && in_array($_GET['record_type'], ['all', 'debts']) ? $_GET['record_type'] : 'all';
$time_period = isset($_GET['time_period']) && in_array($_GET['time_period'], ['date', 'week', 'month', 'year', 'all']) ? $_GET['time_period'] : 'all';
$filter_date = isset($_GET['filter_date']) ? $_GET['filter_date'] : date('Y-m-d');

// Build time filter (disabled for debts as per financial_summary.php)
$time_filter_debts = '';

// Fetch debts data
$sql = "SELECT 
            u.id AS user_id,
            u.member_id,
            IFNULL(u.full_name, 'Unknown') AS full_name,
            po.payment_type,
            COALESCE(pt.required_amount, 0) AS required_amount,
            COALESCE(SUM(p.amount), 0) AS total_paid,
            (COALESCE(pt.required_amount, 0) - COALESCE(SUM(p.amount), 0)) AS debt,
            po.payment_cycle,
            po.event_date
        FROM payment_obligations po
        JOIN users u ON po.user_id = u.id
        JOIN payment_types pt ON po.payment_type = pt.type_name
        LEFT JOIN payments p ON p.user_id = po.user_id 
            AND p.payment_type = po.payment_type 
            AND p.payment_status = 'Paid'
            AND (
                (po.payment_cycle = p.payment_cycle AND po.payment_cycle IS NOT NULL)
                OR (po.event_date = p.event_date AND po.event_date IS NOT NULL)
            )
        WHERE po.deleted_at IS NULL
            AND u.role = 'member'
            AND (u.deleted_at IS NULL OR u.deleted_at > NOW())" . ($record_type == 'all' || $record_type == 'debts' ? $time_filter_debts : ' AND FALSE') . "
        GROUP BY po.id, u.id, pt.required_amount, po.payment_cycle, po.event_date
        HAVING debt > 0
        ORDER BY debt DESC";
$stmt = mysqli_prepare($link, $sql);
if ($time_period == 'date' && !empty($bind_params)) {
    mysqli_stmt_bind_param($stmt, $bind_types, ...$bind_params);
}
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$debts = [];
while ($row = mysqli_fetch_assoc($result)) {
    $debts[] = $row;
}
mysqli_stmt_close($stmt);

// Set headers for CSV download
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="debts_export_' . date('Ymd_His') . '.csv"');

// Create CSV file
$output = fopen('php://output', 'w');
fputcsv($output, ['Member ID', 'Member Name', 'Payment Type', 'Required Amount', 'Total Paid', 'Debt', 'Payment Cycle', 'Event Date']);

foreach ($debts as $record) {
    fputcsv($output, [
        $record['member_id'] ?? 'N/A',
        $record['full_name'],
        $record['payment_type'] ?? 'N/A',
        number_format($record['required_amount'] ?? 0, 2),
        number_format($record['total_paid'] ?? 0, 2),
        number_format($record['debt'] ?? 0, 2),
        $record['payment_cycle'] ?? 'N/A',
        $record['event_date'] ? date('Y-m-d', strtotime($record['event_date'])) : 'N/A'
    ]);
}

fclose($output);
mysqli_close($link);
exit;
?>