<?php
// admin_dashboard.php
require_once 'includes/functions.php';
require_once 'includes/db_config.php';
session_start();

// Check if user is logged in and has admin role
if (!is_logged_in() || $_SESSION['user_role'] !== 'admin') {
    if (is_logged_in() && $_SESSION['user_role'] === 'super_admin') {
        redirect("super_admin_dashboard.php");
    } else {
        redirect("login.php");
    }
}

// Session timeout
$timeout = 1800; // 30 minutes
if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity']) > $timeout) {
    session_unset();
    session_destroy();
    redirect("login.php?timeout=1");
}
$_SESSION['last_activity'] = time();

$system_name = get_setting('system_name', $link) ?? 'Club Portal';
$currency_symbol = get_setting('currency_symbol', $link) ?? '₦';
$username = $_SESSION['user_name'] ?? 'Admin'; // Use user_name from login
$current_datetime = date('l, F j, Y'); // e.g., Sunday, October 12, 2025

// Initialize variables
$total_members = 0;
$total_tokens_purchased = 0;
$available_tokens = 0;
$total_tokens_used = 0;
$debug_info = [];

// Fetch total members (if permitted)
if (user_has_permission($link, 'view_member_directory')) {
    $sql_members = "SELECT COUNT(*) AS total FROM users WHERE role IN ('member', 'pending')";
    $result_members = mysqli_query($link, $sql_members);
    if ($result_members) {
        $row = mysqli_fetch_assoc($result_members);
        $total_members = $row['total'];
        $debug_info['members_query'] = $sql_members;
        $debug_info['total_members'] = $total_members;
        mysqli_free_result($result_members);
    } else {
        error_log("Failed to fetch members: " . mysqli_error($link));
        $debug_info['members_error'] = mysqli_error($link);
    }
}

// Calculate total tokens purchased (sum from approved purchases only)
$sql_tokens_purchased = "SELECT COALESCE(SUM(quantity), 0) AS total FROM token_purchases WHERE status = 'approved'";
$result = mysqli_query($link, $sql_tokens_purchased);
if ($result) {
    $total_tokens_purchased = mysqli_fetch_assoc($result)['total'] ?? 0;
    mysqli_free_result($result);
} else {
    error_log("Failed to fetch tokens purchased: " . mysqli_error($link));
}

// Calculate available tokens (sum of all user balances)
$sql_available_tokens = "SELECT COALESCE(SUM(balance), 0) AS total FROM token_balances";
$result = mysqli_query($link, $sql_available_tokens);
if ($result) {
    $available_tokens = mysqli_fetch_assoc($result)['total'] ?? 0;
    mysqli_free_result($result);
} else {
    error_log("Failed to fetch available tokens: " . mysqli_error($link));
}

// Calculate total tokens used
$sql_tokens_used = "SELECT COALESCE(SUM(tokens_used), 0) AS total FROM token_usage_logs";
$result = mysqli_query($link, $sql_tokens_used);
if ($result) {
    $total_tokens_used = mysqli_fetch_assoc($result)['total'] ?? 0;
    mysqli_free_result($result);
} else {
    error_log("Failed to fetch tokens used: " . mysqli_error($link));
}
?>

<?php require_once 'includes/header.php'; ?>

<script>
// Set dynamic page title
document.title = 'Admin Dashboard - <?php echo htmlspecialchars($system_name); ?>';
</script>

<style>
    .welcome-message {
        background: #f8f9fa;
        padding: 20px;
        border-radius: 10px;
        text-align: center;
        margin-bottom: 20px;
        overflow: hidden;
        position: relative;
    }
    .scrolling-text {
        white-space: nowrap;
        display: inline-block;
        animation: scrollLeft 30s linear infinite;
        padding-left: 100%;
        color: #1a2a44;
        background-color: #f4a261;
        font-size: 1.8rem;
        padding: 5px 10px;
    }
    .scrolling-text:hover {
        animation-play-state: paused;
    }
    @keyframes scrollLeft {
        0% { transform: translateX(100%); }
        100% { transform: translateX(-100%); }
    }
    .main-content {
        padding: 20px;
    }
    .card {
        border: none;
        border-radius: 15px;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        transition: transform 0.3s, box-shadow 0.3s;
    }
    .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 16px rgba(0, 0, 0, 0.2);
    }
    .card-icon {
        font-size: 2.5rem;
        color: #ffffff;
        background-color: #007bff;
        padding: 15px;
        border-radius: 50%;
    }
    .card-title {
        font-size: 1.2rem;
        font-weight: bold;
    }
    .card-text {
        font-size: 1.5rem;
        font-weight: bold;
        color: #333;
    }
</style>

<div class="container-fluid">
    <div class="row">
        <?php require_once 'includes/sidebar.php'; ?>
        <main class="col-md-9 col-lg-10 main-content">
            <h2>Admin Dashboard</h2>
            <hr>

            <!-- Welcome Message -->
            <div class="welcome-message">
                <div class="scrolling-text">
                    Welcome, <?php echo htmlspecialchars($username); ?>! Today is <?php echo $current_datetime; ?>. Assotrack Makes your work easier, builds trust and transparency- Use it! Love It!.
                </div>
            </div>

            <!-- Metrics Overview -->
            <div class="row g-4 mb-4">
                <!-- Total Members Card -->
                <div class="col-md-4 col-lg-3">
                    <div class="card bg-light">
                        <div class="card-body text-center">
                            <i class="fas fa-users card-icon"></i>
                            <h5 class="card-title mt-3">Total Members</h5>
                            <p class="card-text"><?php echo htmlspecialchars($total_members); ?></p>
                        </div>
                    </div>
                </div>
                <!-- Total Tokens Purchased Card -->
                <div class="col-md-4 col-lg-3">
                    <div class="card bg-light">
                        <div class="card-body text-center">
                            <i class="fas fa-coins card-icon" style="background-color: #28a745;"></i>
                            <h5 class="card-title mt-3">Total Tokens Purchased</h5>
                            <p class="card-text"><?php echo htmlspecialchars($total_tokens_purchased); ?></p>
                        </div>
                    </div>
                </div>
                <!-- Available Tokens Card -->
                <div class="col-md-4 col-lg-3">
                    <div class="card bg-light">
                        <div class="card-body text-center">
                            <i class="fas fa-wallet card-icon" style="background-color: #17a2b8;"></i>
                            <h5 class="card-title mt-3">Available Tokens</h5>
                            <p class="card-text"><?php echo htmlspecialchars($available_tokens); ?></p>
                        </div>
                    </div>
                </div>
                <!-- Total Tokens Used Card -->
                <div class="col-md-4 col-lg-3">
                    <div class="card bg-light">
                        <div class="card-body text-center">
                            <i class="fas fa-hand-holding-usd card-icon" style="background-color: #dc3545;"></i>
                            <h5 class="card-title mt-3">Total Tokens Used</h5>
                            <p class="card-text"><?php echo htmlspecialchars($total_tokens_used); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Quick Actions Section -->
            <?php if (user_has_permission($link, 'view_payments') || user_has_permission($link, 'view_member_directory') || user_has_permission($link, 'view_debts') || user_has_permission($link, 'view_benefits') || user_has_permission($link, 'manage_members') || user_has_permission($link, 'manage_news') || user_has_permission($link, 'manage_messages') || user_has_permission($link, 'manage_forms') || user_has_permission($link, 'view_settings')): ?>
                <div class="card mb-4">
                    <div class="card-header">Quick Actions</div>
                    <div class="card-body">
                        <div class="d-flex flex-wrap gap-2">
                            <?php if (user_has_permission($link, 'view_payments')): ?>
                                <a href="manage_payment_types.php" class="btn btn-outline-primary"><i class="fas fa-money-bill-wave me-2"></i>Manage Payments</a>
                            <?php endif; ?>
                            <?php if (user_has_permission($link, 'view_member_directory')): ?>
                                <a href="member_directory.php" class="btn btn-outline-primary"><i class="fas fa-users me-2"></i>View Member Directory</a>
                            <?php endif; ?>
                            <?php if (user_has_permission($link, 'view_debts')): ?>
                                <a href="manage_payment_types.php" class="btn btn-outline-primary"><i class="fas fa-money-bill-alt me-2"></i>Manage Debts</a>
                            <?php endif; ?>
                            <?php if (user_has_permission($link, 'view_benefits')): ?>
                                <a href="manage_payment_types.php" class="btn btn-outline-primary"><i class="fas fa-gift me-2"></i>Manage Benefits</a>
                            <?php endif; ?>
                            <?php if (user_has_permission($link, 'manage_members')): ?>
                                <a href="member_management.php" class="btn btn-outline-primary"><i class="fas fa-users-cog me-2"></i>Manage Members</a>
                            <?php endif; ?>
                            <?php if (user_has_permission($link, 'manage_news')): ?>
                                <a href="announcement_management.php" class="btn btn-outline-primary"><i class="fas fa-bullhorn me-2"></i>Manage Announcements</a>
                            <?php endif; ?>
                            <?php if (user_has_permission($link, 'manage_messages')): ?>
                                <a href="messages_admin.php" class="btn btn-outline-primary"><i class="fas fa-envelope me-2"></i>Manage Messages</a>
                            <?php endif; ?>
                            <?php if (user_has_permission($link, 'manage_forms')): ?>
                                <a href="form_builder.php" class="btn btn-outline-primary"><i class="fas fa-cogs me-2"></i>Form Builder</a>
                            <?php endif; ?>
                            <?php if (user_has_permission($link, 'view_settings')): ?>
                                <a href="admin_settings.php" class="btn btn-outline-primary"><i class="fas fa-cogs me-2"></i>Admin Settings</a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </main>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // No JavaScript required for this version
});
</script>

<?php require_once 'includes/footer.php'; ?>