<?php
// members/view.php
require_once '../includes/functions.php';
require_once '../includes/db_config.php';
if (!is_logged_in() || !is_admin()) redirect("login.php");

$id = (int)($_GET['id'] ?? 0);
$stmt = $link->prepare("SELECT * FROM users WHERE id = ? AND role IN ('member','pending')");
$stmt->bind_param("i", $id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
if (!$user) redirect("list.php");

$form_data = [];
if ($user['id']) {
    $fd = $link->query("SELECT data FROM form_data WHERE user_id = {$user['id']} LIMIT 1")->fetch_assoc();
    $form_data = $fd ? json_decode($fd['data'], true) : [];
}
?>

<?php include '../includes/header.php'; ?>
<div class="container-fluid">
    <div class="row">
        <?php include '../includes/sidebar.php'; ?>
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <h2>Member Profile: <?=htmlspecialchars($user['full_name'])?></h2>
            <div class="row">
                <div class="col-md-4 text-center">
                    <img src="../uploads/profiles/<?=htmlspecialchars($user['profile_image'] ?? 'default.png')?>" class="img-fluid rounded" style="max-width:200px;">
                    <br><br>
                    <a href="id-card.php?id=<?=$user['id']?>" target="_blank" class="btn btn-success">Generate ID Card</a>
                </div>
                <div class="col-md-8">
                    <table class="table table-bordered">
                        <tr><th>Member ID</th><td><?=htmlspecialchars($user['member_id'])?></td></tr>
                        <tr><th>Name</th><td><?=htmlspecialchars($user['full_name'])?></td></tr>
                        <tr><th>Sex</th><td><?=ucfirst($user['sex'] ?? '-')?></td></tr>
                        <tr><th>Address</th><td><?=nl2br(htmlspecialchars($user['address'] ?? '-'))?></td></tr>
                        <tr><th>Email</th><td><?=htmlspecialchars($user['email'])?></td></tr>
                        <tr><th>Phone</th><td><?=htmlspecialchars($user['phone'] ?? '-')?></td></tr>
                        <tr><th>Status</th><td><span class="badge bg-<?=status_color($user['membership_status'])?>"><?=htmlspecialchars($user['membership_status'])?></span></td></tr>
                        <tr><th>Expiry</th><td><?=format_date($user['membership_expiry'])?></td></tr>
                        <tr><th>Position</th><td><?=htmlspecialchars($user['position'] ?? 'Member')?></td></tr>
                    </table>

                    <h5>Form Data</h5>
                    <pre><?php print_r($form_data); ?></pre>
                </div>
            </div>
        </main>
    </div>
</div>
<?php include '../includes/footer.php'; ?>