<?php
// verify_id.php - PUBLIC (NO LOGIN)
require_once 'includes/db_config.php';
require_once 'includes/functions.php'; // <-- ADDED

$member_id = trim($_GET['id'] ?? '');
if (empty($member_id)) {
    http_response_code(404);
    die('Invalid ID.');
}

$sql = "SELECT full_name, membership_status, role, created_at, profile_picture 
        FROM users 
        WHERE member_id = ? 
          AND role IN ('member','pending')
          AND (deleted_at IS NULL OR deleted_at > NOW())";
$stmt = mysqli_prepare($link, $sql);
mysqli_stmt_bind_param($stmt, 's', $member_id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$row = mysqli_fetch_assoc($result);
mysqli_stmt_close($stmt);

if (!$row) {
    http_response_code(404);
    die('Member not found or ID invalid.');
}

$system_name = get_setting('system_name', $link) ?? 'Club Portal';
$status = strtolower($row['membership_status']) === 'approved' ? 'Active' : 'Inactive';
$position = ucfirst(str_replace(
    ['member', 'president', 'secretary', 'accountant'],
    ['Member', 'President', 'Secretary', 'Accountant'],
    strtolower($row['role'] ?? 'member')
));
$joined = date('M Y', strtotime($row['created_at']));

// DEFAULT PHOTO
$default_photo = 'uploads/profile_pictures/default.png';
if (!file_exists($_SERVER['DOCUMENT_ROOT'] . '/' . $default_photo)) {
    $img = imagecreatetruecolor(200, 200);
    $bg = imagecolorallocate($img, 255, 255, 255);
    $text = imagecolorallocate($img, 200, 200, 200);
    imagefilledrectangle($img, 0, 0, 200, 200, $bg);
    imagestring($img, 5, 50, 90, 'NO PHOTO', $text);
    imagepng($img, $_SERVER['DOCUMENT_ROOT'] . '/' . $default_photo);
    imagedestroy($img);
}
$photo = $row['profile_picture'] ?: $default_photo;
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Verify Member ID - <?= htmlspecialchars($system_name) ?></title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 400px; margin: 40px auto; text-align: center; border: 2px solid #28a745; padding: 20px; border-radius: 12px; background: #f8fff9; }
        .verified { color: #28a745; font-size: 2em; }
        .status { padding: 10px 20px; border-radius: 30px; font-weight: bold; margin: 15px 0; display: inline-block; }
        .active { background: #d4edda; color: #155724; }
        .inactive { background: #f8d7da; color: #721c24; }
        .photo { width: 100px; height: 100px; border-radius: 50%; border: 3px solid #28a745; object-fit: cover; margin: 10px auto; }
        .footer { margin-top: 20px; font-size: 0.8em; color: #666; }
    </style>
</head>
<body>
    <div class="verified">ID Verified</div>
    <img src="<?= htmlspecialchars($photo) ?>" class="photo" onerror="this.src='<?= $default_photo ?>'">
    <h3><?= htmlspecialchars($row['full_name']) ?></h3>
    <p><strong>Member ID:</strong> <?= htmlspecialchars($member_id) ?></p>
    <div class="status <?= $status === 'Active' ? 'active' : 'inactive' ?>">
        Status: <?= $status ?>
    </div>
    <p><strong>Position:</strong> <?= $position ?></p>
    <p><em>Joined: <?= $joined ?></em></p>
    <div class="footer">
        Verified via <strong><?= htmlspecialchars($system_name) ?></strong> Official Records
    </div>
</body>
</html>