<?php
// payment_details.php
require_once 'includes/functions.php';
require_once 'includes/db_config.php';
session_start();

// Check if user is logged in and is a member
if (!is_logged_in() || is_admin()) {
    redirect("login.php");
}

// Fetch payment details
$account_name = get_setting('account_name', $link) ?? 'Not Set';
$bank_name = get_setting('bank_name', $link) ?? 'Not Set';
$account_number = get_setting('account_number', $link) ?? 'Not Set';
$system_name = get_setting('system_name', $link) ?? 'Club Portal';
?>

<?php require_once 'includes/header.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Details - <?php echo htmlspecialchars($system_name); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <?php require_once 'includes/sidebar.php'; ?>
            <main class="col-md-9 col-lg-10 main-content">
                <h2>Payment Details</h2>
                <div class="card mb-4">
                    <div class="card-header">Club Bank Account Details</div>
                    <div class="card-body">
                        <?php if ($account_name === 'Not Set' || $bank_name === 'Not Set' || $account_number === 'Not Set'): ?>
                            <div class="alert alert-warning">
                                Payment details have not been set by the administrator. Please contact support for assistance.
                            </div>
                        <?php else: ?>
                            <p>Please make your payment to the following bank account. Ensure you include your member ID or name as the payment reference.</p>
                            <ul class="list-group">
                                <li class="list-group-item"><strong>Account Name:</strong> <?php echo htmlspecialchars($account_name); ?></li>
                                <li class="list-group-item"><strong>Bank Name:</strong> <?php echo htmlspecialchars($bank_name); ?></li>
                                <li class="list-group-item"><strong>Account Number:</strong> <?php echo htmlspecialchars($account_number); ?></li>
                            </ul>
                        <?php endif; ?>
                        <div class="mt-3">
                            <a href="my_payments.php" class="btn btn-primary">View Payment History</a>
                            <a href="member_dashboard.php" class="btn btn-secondary">Back to Dashboard</a>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
</body>
</html>
<?php require_once 'includes/footer.php'; ?>