<?php
// manage_payment_types.php
ob_start();
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once 'includes/functions.php';
require_once 'includes/db_config.php';
// Check if user is logged in and is an admin
if (!is_logged_in() || !is_admin()) {
    redirect("login.php");
    exit;
}
$message = '';
$message_type = '';
$currency_symbol = get_setting('currency_symbol', $link) ?? '₦';
// Handle form submissions
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Add Payment Type
    if (isset($_POST['add_payment_type'])) {
        $type_name = sanitize_input($_POST['payment_type_name'] ?? '');
        $required_amount = floatval($_POST['required_amount'] ?? 0);
        $payment_category = sanitize_input($_POST['payment_category'] ?? '');
        
        // --- UPDATE: Set amount to 0 if category is donation or other_income ---
        if (in_array($payment_category, ['donation', 'other_income'])) {
            $required_amount = 0.0;
        }

        $recurrence_interval = ($payment_category === 'recurring') ? sanitize_input($_POST['recurrence_interval'] ?? 'none') : 'none';
        $event_date = ($payment_category === 'event') ? sanitize_input($_POST['event_date'] ?? null) : null;
        if ($payment_category === 'event' && empty($event_date)) {
            $message = "Event date is required for event-based payment types.";
            $message_type = 'danger';
        } else {
            $sql_check = "SELECT COUNT(*) FROM payment_types WHERE type_name = ? AND deleted_at IS NULL";
            if ($stmt_check = mysqli_prepare($link, $sql_check)) {
                mysqli_stmt_bind_param($stmt_check, "s", $type_name);
                mysqli_stmt_execute($stmt_check);
                $count = mysqli_fetch_row(mysqli_stmt_get_result($stmt_check))[0];
                mysqli_stmt_close($stmt_check);
                if ($count > 0) {
                    $message = "Payment type name '$type_name' already exists.";
                    $message_type = 'danger';
                } elseif (!empty($type_name) && $required_amount >= 0 && !empty($payment_category)) {
                    $sql_pt = "INSERT INTO payment_types (type_name, required_amount, payment_category, recurrence_interval, event_date) VALUES (?, ?, ?, ?, ?)";
                    if ($stmt_pt = mysqli_prepare($link, $sql_pt)) {
                        mysqli_stmt_bind_param($stmt_pt, "sdsss", $type_name, $required_amount, $payment_category, $recurrence_interval, $event_date);
                        if (mysqli_stmt_execute($stmt_pt)) {
                            $message = "Payment type added successfully!";
                            $message_type = 'success';
                            $sql_update = "UPDATE payment_obligations SET required_amount = ? WHERE payment_type = ? AND required_amount IS NULL";
                            if ($stmt_update = mysqli_prepare($link, $sql_update)) {
                                mysqli_stmt_bind_param($stmt_update, "ds", $required_amount, $type_name);
                                mysqli_stmt_execute($stmt_update);
                                mysqli_stmt_close($stmt_update);
                            }
                            include 'generate_obligations.php';
                        } else {
                            $message = "Error adding payment type: " . mysqli_error($link);
                            $message_type = 'danger';
                        }
                        mysqli_stmt_close($stmt_pt);
                    } else {
                        $message = "Error preparing payment type statement: " . mysqli_error($link);
                        $message_type = 'danger';
                    }
                } else {
                    $message = "Payment type name, non-negative amount, and category are required.";
                    $message_type = 'danger';
                }
            }
        }
    } elseif (isset($_POST['edit_payment_type'])) {
        $type_id = intval($_POST['payment_type_id']);
        $type_name = sanitize_input($_POST['payment_type_name'] ?? '');
        $required_amount = floatval($_POST['required_amount'] ?? 0);
        $payment_category = sanitize_input($_POST['payment_category'] ?? '');

        // --- UPDATE: Set amount to 0 if category is donation or other_income ---
        if (in_array($payment_category, ['donation', 'other_income'])) {
            $required_amount = 0.0;
        }

        $recurrence_interval = ($payment_category === 'recurring') ? sanitize_input($_POST['recurrence_interval'] ?? 'none') : 'none';
        $event_date = ($payment_category === 'event') ? sanitize_input($_POST['event_date'] ?? null) : null;
        if ($payment_category === 'event' && empty($event_date)) {
            $message = "Event date is required for event-based payment types.";
            $message_type = 'danger';
        } else {
            $sql_check = "SELECT COUNT(*) FROM payment_types WHERE type_name = ? AND id != ? AND deleted_at IS NULL";
            if ($stmt_check = mysqli_prepare($link, $sql_check)) {
                mysqli_stmt_bind_param($stmt_check, "si", $type_name, $type_id);
                mysqli_stmt_execute($stmt_check);
                $count = mysqli_fetch_row(mysqli_stmt_get_result($stmt_check))[0];
                mysqli_stmt_close($stmt_check);
                if ($count > 0) {
                    $message = "Payment type name '$type_name' already exists.";
                    $message_type = 'danger';
                } elseif (!empty($type_name) && $required_amount >= 0 && !empty($payment_category)) {
                    $sql_pt = "UPDATE payment_types SET type_name = ?, required_amount = ?, payment_category = ?, recurrence_interval = ?, event_date = ? WHERE id = ?";
                    if ($stmt_pt = mysqli_prepare($link, $sql_pt)) {
                        mysqli_stmt_bind_param($stmt_pt, "sdsssi", $type_name, $required_amount, $payment_category, $recurrence_interval, $event_date, $type_id);
                        if (mysqli_stmt_execute($stmt_pt)) {
                            $message = "Payment type updated successfully!";
                            $message_type = 'success';
                            $sql_update = "UPDATE payment_obligations SET required_amount = ? WHERE payment_type = ?";
                            if ($stmt_update = mysqli_prepare($link, $sql_update)) {
                                mysqli_stmt_bind_param($stmt_update, "ds", $required_amount, $type_name);
                                mysqli_stmt_execute($stmt_update);
                                mysqli_stmt_close($stmt_update);
                            }
                            include 'generate_obligations.php';
                        } else {
                            $message = "Error updating payment type: " . mysqli_error($link);
                            $message_type = 'danger';
                        }
                        mysqli_stmt_close($stmt_pt);
                    } else {
                        $message = "Error preparing payment type statement: " . mysqli_error($link);
                        $message_type = 'danger';
                    }
                } else {
                    $message = "Payment type name, non-negative amount, and category are required.";
                    $message_type = 'danger';
                }
            }
        }
    } elseif (isset($_POST['delete_payment_type'])) {
        // ... (delete logic remains the same) ...
        $type_id = intval($_POST['payment_type_id']);
        $sql_check = "SELECT COUNT(*) FROM payments WHERE payment_type = (SELECT type_name FROM payment_types WHERE id = ?)";
        if ($stmt_check = mysqli_prepare($link, $sql_check)) {
            mysqli_stmt_bind_param($stmt_check, "i", $type_id);
            mysqli_stmt_execute($stmt_check);
            $count = mysqli_fetch_row(mysqli_stmt_get_result($stmt_check))[0];
            mysqli_stmt_close($stmt_check);
            if ($count > 0) {
                $message = "Cannot delete payment type; it is in use.";
                $message_type = 'danger';
            } else {
                $sql = "UPDATE payment_types SET deleted_at = NOW() WHERE id = ?";
                if ($stmt = mysqli_prepare($link, $sql)) {
                    mysqli_stmt_bind_param($stmt, "i", $type_id);
                    if (mysqli_stmt_execute($stmt)) {
                        $message = "Payment type deleted successfully!";
                        $message_type = 'success';
                    } else {
                        $message = "Error deleting payment type: " . mysqli_error($link);
                        $message_type = 'danger';
                    }
                    mysqli_stmt_close($stmt);
                }
            }
        }
    } elseif (isset($_POST['add_expense_type'])) {
        // ... (expense logic remains the same) ...
        $type_name = sanitize_input($_POST['expense_type_name'] ?? '');
        $sql_check = "SELECT COUNT(*) FROM expense_types WHERE type_name = ? AND deleted_at IS NULL";
        if ($stmt_check = mysqli_prepare($link, $sql_check)) {
            mysqli_stmt_bind_param($stmt_check, "s", $type_name);
            mysqli_stmt_execute($stmt_check);
            $count = mysqli_fetch_row(mysqli_stmt_get_result($stmt_check))[0];
            mysqli_stmt_close($stmt_check);
            if ($count > 0) {
                $message = "Expense type name '$type_name' already exists.";
                $message_type = 'danger';
            } elseif (!empty($type_name)) {
                $sql = "INSERT INTO expense_types (type_name) VALUES (?)";
                if ($stmt = mysqli_prepare($link, $sql)) {
                    mysqli_stmt_bind_param($stmt, "s", $type_name);
                    if (mysqli_stmt_execute($stmt)) {
                        $message = "Expense type added successfully!";
                        $message_type = 'success';
                    } else {
                        $message = "Error adding expense type: " . mysqli_error($link);
                        $message_type = 'danger';
                    }
                    mysqli_stmt_close($stmt);
                }
            } else {
                $message = "Expense type name is required.";
                $message_type = 'danger';
            }
        }
    } elseif (isset($_POST['edit_expense_type'])) {
        // ... (expense logic remains the same) ...
        $type_id = intval($_POST['expense_type_id']);
        $type_name = sanitize_input($_POST['expense_type_name'] ?? '');
        $sql_check = "SELECT COUNT(*) FROM expense_types WHERE type_name = ? AND id != ? AND deleted_at IS NULL";
        if ($stmt_check = mysqli_prepare($link, $sql_check)) {
            mysqli_stmt_bind_param($stmt_check, "si", $type_name, $type_id);
            mysqli_stmt_execute($stmt_check);
            $count = mysqli_fetch_row(mysqli_stmt_get_result($stmt_check))[0];
            mysqli_stmt_close($stmt_check);
            if ($count > 0) {
                $message = "Expense type name '$type_name' already exists.";
                $message_type = 'danger';
            } elseif (!empty($type_name)) {
                $sql = "UPDATE expense_types SET type_name = ? WHERE id = ?";
                if ($stmt = mysqli_prepare($link, $sql)) {
                    mysqli_stmt_bind_param($stmt, "si", $type_name, $type_id);
                    if (mysqli_stmt_execute($stmt)) {
                        $message = "Expense type updated successfully!";
                        $message_type = 'success';
                    } else {
                        $message = "Error updating expense type: " . mysqli_error($link);
                        $message_type = 'danger';
                    }
                    mysqli_stmt_close($stmt);
                }
            } else {
                $message = "Expense type name is required.";
                $message_type = 'danger';
            }
        }
    } elseif (isset($_POST['delete_expense_type'])) {
        // ... (expense logic remains the same) ...
        $type_id = intval($_POST['expense_type_id']);
        $sql_check = "SELECT COUNT(*) FROM expenses WHERE expense_type_id = ?";
        if ($stmt_check = mysqli_prepare($link, $sql_check)) {
            mysqli_stmt_bind_param($stmt_check, "i", $type_id);
            mysqli_stmt_execute($stmt_check);
            $count = mysqli_fetch_row(mysqli_stmt_get_result($stmt_check))[0];
            mysqli_stmt_close($stmt_check);
            if ($count > 0) {
                $message = "Cannot delete expense type; it is in use.";
                $message_type = 'danger';
            } else {
                $sql = "UPDATE expense_types SET deleted_at = NOW() WHERE id = ?";
                if ($stmt = mysqli_prepare($link, $sql)) {
                    mysqli_stmt_bind_param($stmt, "i", $type_id);
                    if (mysqli_stmt_execute($stmt)) {
                        $message = "Expense type deleted successfully!";
                        $message_type = 'success';
                    } else {
                        $message = "Error deleting expense type: " . mysqli_error($link);
                        $message_type = 'danger';
                    }
                    mysqli_stmt_close($stmt);
                }
            }
        }
    } elseif (isset($_POST['add_benefit_type'])) {
        // ... (benefit logic remains the same) ...
        $type_name = sanitize_input($_POST['benefit_type_name'] ?? '');
        $sql_check = "SELECT COUNT(*) FROM benefit_types WHERE type_name = ? AND deleted_at IS NULL";
        if ($stmt_check = mysqli_prepare($link, $sql_check)) {
            mysqli_stmt_bind_param($stmt_check, "s", $type_name);
            mysqli_stmt_execute($stmt_check);
            $count = mysqli_fetch_row(mysqli_stmt_get_result($stmt_check))[0];
            mysqli_stmt_close($stmt_check);
            if ($count > 0) {
                $message = "Benefit type name '$type_name' already exists.";
                $message_type = 'danger';
            } elseif (!empty($type_name)) {
                $sql = "INSERT INTO benefit_types (type_name) VALUES (?)";
                if ($stmt = mysqli_prepare($link, $sql)) {
                    mysqli_stmt_bind_param($stmt, "s", $type_name);
                    if (mysqli_stmt_execute($stmt)) {
                        $message = "Benefit type added successfully!";
                        $message_type = 'success';
                    } else {
                        $message = "Error adding benefit type: " . mysqli_error($link);
                        $message_type = 'danger';
                    }
                    mysqli_stmt_close($stmt);
                }
            } else {
                $message = "Benefit type name is required.";
                $message_type = 'danger';
            }
        }
    } elseif (isset($_POST['edit_benefit_type'])) {
        // ... (benefit logic remains the same) ...
        $type_id = intval($_POST['benefit_type_id']);
        $type_name = sanitize_input($_POST['benefit_type_name'] ?? '');
        $sql_check = "SELECT COUNT(*) FROM benefit_types WHERE type_name = ? AND id != ? AND deleted_at IS NULL";
        if ($stmt_check = mysqli_prepare($link, $sql_check)) {
            mysqli_stmt_bind_param($stmt_check, "si", $type_name, $type_id);
            mysqli_stmt_execute($stmt_check);
            $count = mysqli_fetch_row(mysqli_stmt_get_result($stmt_check))[0];
            mysqli_stmt_close($stmt_check);
            if ($count > 0) {
                $message = "Benefit type name '$type_name' already exists.";
                $message_type = 'danger';
            } elseif (!empty($type_name)) {
                $sql = "UPDATE benefit_types SET type_name = ? WHERE id = ?";
                if ($stmt = mysqli_prepare($link, $sql)) {
                    mysqli_stmt_bind_param($stmt, "si", $type_name, $type_id);
                    if (mysqli_stmt_execute($stmt)) {
                        $message = "Benefit type updated successfully!";
                        $message_type = 'success';
                    } else {
                        $message = "Error updating benefit type: " . mysqli_error($link);
                        $message_type = 'danger';
                    }
                    mysqli_stmt_close($stmt);
                }
            } else {
                $message = "Benefit type name is required.";
                $message_type = 'danger';
            }
        }
    } elseif (isset($_POST['delete_benefit_type'])) {
        // ... (benefit logic remains the same) ...
        $type_id = intval($_POST['benefit_type_id']);
        $sql_check = "SELECT COUNT(*) FROM member_benefits WHERE benefit_type_id = ?";
        if ($stmt_check = mysqli_prepare($link, $sql_check)) {
            mysqli_stmt_bind_param($stmt_check, "i", $type_id);
            mysqli_stmt_execute($stmt_check);
            $count = mysqli_fetch_row(mysqli_stmt_get_result($stmt_check))[0];
            mysqli_stmt_close($stmt_check);
            if ($count > 0) {
                $message = "Cannot delete benefit type; it is in use.";
                $message_type = 'danger';
            } else {
                $sql = "UPDATE benefit_types SET deleted_at = NOW() WHERE id = ?";
                if ($stmt = mysqli_prepare($link, $sql)) {
                    mysqli_stmt_bind_param($stmt, "i", $type_id);
                    if (mysqli_stmt_execute($stmt)) {
                        $message = "Benefit type deleted successfully!";
                        $message_type = 'success';
                    } else {
                        $message = "Error deleting benefit type: " . mysqli_error($link);
                        $message_type = 'danger';
                    }
                    mysqli_stmt_close($stmt);
                }
            }
        }
    }
}
// Fetch data for forms and tables
$payment_types = [];
$sql = "SELECT id, type_name, COALESCE(required_amount, 0) AS required_amount, payment_category, recurrence_interval, event_date FROM payment_types WHERE deleted_at IS NULL ORDER BY type_name";
$result = mysqli_query($link, $sql);
if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        $payment_types[] = $row;
    }
}
$expense_types = [];
$sql = "SELECT id, type_name FROM expense_types WHERE deleted_at IS NULL ORDER BY type_name";
$result = mysqli_query($link, $sql);
if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        $expense_types[] = $row;
    }
}
$benefit_types = [];
$sql = "SELECT id, type_name FROM benefit_types WHERE deleted_at IS NULL ORDER BY type_name";
$result = mysqli_query($link, $sql);
if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        $benefit_types[] = $row;
    }
}
ob_end_clean();
?>
<?php require_once 'includes/header.php'; ?>
<script>
// Set dynamic page title
document.title = 'Manage Types - <?php echo htmlspecialchars(get_setting('system_name', $link) ?? 'Club Portal'); ?>';
</script>
<style>
.modal-backdrop.show {
    opacity: 0.5;
    z-index: 1040;
}
.modal {
    z-index: 1050;
}
.main-content {
    padding: 20px;
}
.table-responsive {
    max-height: 500px;
    overflow-y: auto;
}
</style>
<div class="container-fluid">
    <div class="row">
        <?php require_once 'includes/sidebar.php'; ?>
        <main class="col-md-9 col-lg-10 main-content">
            <h2>Manage Types</h2>
            <?php if ($message): ?>
                <div class="alert alert-<?php echo htmlspecialchars($message_type); ?>" role="alert">
                    <?php echo htmlspecialchars($message); ?>
                </div>
            <?php endif; ?>
            <ul class="nav nav-tabs mb-4" id="financeTabs" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active" id="payment-type-tab" data-bs-toggle="tab" href="#payment-type" role="tab" aria-controls="payment-type" aria-selected="true">Payment Types</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="expense-type-tab" data-bs-toggle="tab" href="#expense-type" role="tab" aria-controls="expense-type" aria-selected="false">Expense Types</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="benefit-type-tab" data-bs-toggle="tab" href="#benefit-type" role="tab" aria-controls="benefit-type" aria-selected="false">Benefit Types</a>
                </li>
            </ul>
            <div class="tab-content" id="financeTabsContent">
                <!-- Payment Types Tab -->
                <div class="tab-pane fade show active" id="payment-type" role="tabpanel" aria-labelledby="payment-type-tab">
                    <div class="card mb-4">
                        <div class="card-header">Add New Payment Type</div>
                        <div class="card-body">
                            <form action="manage_payment_types.php" method="post" class="mb-3">
                                <input type="hidden" name="add_payment_type" value="1">
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <label for="payment_type_name" class="form-label">Payment Type Name</label>
                                        <input type="text" class="form-control" id="payment_type_name" name="payment_type_name" required>
                                    </div>
                                    <div class="col-md-6" id="required_amount_container">
                                        <label for="required_amount" class="form-label">Required Amount (<?php echo htmlspecialchars($currency_symbol); ?>)</label>
                                        <input type="number" class="form-control" id="required_amount" name="required_amount" step="0.01" min="0">  <!-- Removed 'required' to allow blank/0 for donations -->
                                        <small class="form-text text-muted">Optional (defaults to 0 if blank). Hidden for Donation/Income.</small>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="payment_category" class="form-label">Payment Category</label>
                                        <select name="payment_category" id="payment_category" class="form-select" required onchange="updateCategoryFields()">
                                            <option value="">Select Category</option>
                                            <option value="recurring">Recurring</option>
                                            <option value="freewill">Freewill</option>
                                            <option value="event">Event</option>
                                            <option value="donation">Donation</option>
                                            <!-- --- NEW OPTION ADDED --- -->
                                            <option value="other_income">Other Income</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6" id="recurrence_interval_container" style="display: none;">
                                        <label for="recurrence_interval" class="form-label">Recurrence Interval</label>
                                        <select name="recurrence_interval" id="recurrence_interval" class="form-select">
                                            <option value="weekly">Weekly</option>
                                            <option value="monthly">Monthly</option>
                                            <option value="yearly">Yearly</option>
                                            <option value="none">None</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6" id="event_date_container" style="display: none;">
                                        <label for="event_date" class="form-label">Event Date</label>
                                        <input type="datetime-local" class="form-control" id="event_date" name="event_date">
                                    </div>
                                    <div class="col-12">
                                        <button type="submit" class="btn btn-primary mt-2">Add Payment Type</button>
                                    </div>
                                </div>
                            </form>
                            <hr>
                            <h5>Existing Payment Types</h5>
                            <div class="table-responsive">
                                <table class="table table-striped table-hover">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Amount (<?php echo htmlspecialchars($currency_symbol); ?>)</th>
                                            <th>Category</th>
                                            <th>Recurrence</th>
                                            <th>Event Date</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if (empty($payment_types)): ?>
                                            <tr><td colspan="6" class="text-center">No payment types found.</td></tr>
                                        <?php else: ?>
                                            <?php foreach ($payment_types as $type): ?>
                                                <tr>
                                                    <td><?php echo htmlspecialchars($type['type_name']); ?></td>
                                                    <td><?php echo htmlspecialchars($currency_symbol . ' ' . number_format($type['required_amount'], 2)); ?></td>
                                                    <td><?php echo htmlspecialchars(ucfirst($type['payment_category'])); ?></td>
                                                    <td><?php echo htmlspecialchars(ucfirst($type['recurrence_interval'])); ?></td>
                                                    <td><?php echo htmlspecialchars($type['event_date'] ? date('Y-m-d H:i', strtotime($type['event_date'])) : 'N/A'); ?></td>
                                                    <td>
                                                        <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#editPaymentTypeModal<?php echo htmlspecialchars($type['id']); ?>">Edit</button>
                                                        <form action="manage_payment_types.php" method="post" style="display:inline;">
                                                            <input type="hidden" name="payment_type_id" value="<?php echo htmlspecialchars($type['id']); ?>">
                                                            <button type="submit" name="delete_payment_type" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure? This action cannot be undone.');">Delete</button>
                                                        </form>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Expense Types Tab -->
                <div class="tab-pane fade" id="expense-type" role="tabpanel" aria-labelledby="expense-type-tab">
                    <!-- ... (expense type content remains the same) ... -->
                    <div class="card mb-4">
                        <div class="card-header">Add New Expense Type</div>
                        <div class="card-body">
                            <form action="manage_payment_types.php" method="post" class="mb-3">
                                <input type="hidden" name="add_expense_type" value="1">
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <label for="expense_type_name" class="form-label">Expense Type Name</label>
                                        <input type="text" class="form-control" id="expense_type_name" name="expense_type_name" required>
                                    </div>
                                    <div class="col-12">
                                        <button type="submit" class="btn btn-primary mt-2">Add Expense Type</button>
                                    </div>
                                </div>
                            </form>
                            <hr>
                            <h5>Existing Expense Types</h5>
                            <div class="table-responsive">
                                <table class="table table-striped table-hover">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if (empty($expense_types)): ?>
                                            <tr><td colspan="2" class="text-center">No expense types found.</td></tr>
                                        <?php else: ?>
                                            <?php foreach ($expense_types as $type): ?>
                                                <tr>
                                                    <td><?php echo htmlspecialchars($type['type_name']); ?></td>
                                                    <td>
                                                        <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#editExpenseTypeModal<?php echo htmlspecialchars($type['id']); ?>">Edit</button>
                                                        <form action="manage_payment_types.php" method="post" style="display:inline;">
                                                            <input type="hidden" name="expense_type_id" value="<?php echo htmlspecialchars($type['id']); ?>">
                                                            <button type="submit" name="delete_expense_type" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure? This action cannot be undone.');">Delete</button>
                                                        </form>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Benefit Types Tab -->
                <div class="tab-pane fade" id="benefit-type" role="tabpanel" aria-labelledby="benefit-type-tab">
                    <!-- ... (benefit type content remains the same) ... -->
                    <div class="card mb-4">
                        <div class="card-header">Add New Benefit Type</div>
                        <div class="card-body">
                            <form action="manage_payment_types.php" method="post" class="mb-3">
                                <input type="hidden" name="add_benefit_type" value="1">
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <label for="benefit_type_name" class="form-label">Benefit Type Name</label>
                                        <input type="text" class="form-control" id="benefit_type_name" name="benefit_type_name" required>
                                    </div>
                                    <div class="col-12">
                                        <button type="submit" class="btn btn-primary mt-2">Add Benefit Type</button>
                                    </div>
                                </div>
                            </form>
                            <hr>
                            <h5>Existing Benefit Types</h5>
                            <div class="table-responsive">
                                <table class="table table-striped table-hover">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if (empty($benefit_types)): ?>
                                            <tr><td colspan="2" class="text-center">No benefit types found.</td></tr>
                                        <?php else: ?>
                                            <?php foreach ($benefit_types as $type): ?>
                                                <tr>
                                                    <td><?php echo htmlspecialchars($type['type_name']); ?></td>
                                                    <td>
                                                        <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#editBenefitTypeModal<?php echo htmlspecialchars($type['id']); ?>">Edit</button>
                                                        <form action="manage_payment_types.php" method="post" style="display:inline;">
                                                            <input type="hidden" name="benefit_type_id" value="<?php echo htmlspecialchars($type['id']); ?>">
                                                            <button type="submit" name="delete_benefit_type" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure? This action cannot be undone.');">Delete</button>
                                                        </form>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Modals for Editing Payment Types -->
            <?php foreach ($payment_types as $type): ?>
                <div class="modal fade" id="editPaymentTypeModal<?php echo htmlspecialchars($type['id']); ?>" tabindex="-1" aria-labelledby="editPaymentTypeModalLabel<?php echo htmlspecialchars($type['id']); ?>" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="editPaymentTypeModalLabel<?php echo htmlspecialchars($type['id']); ?>">Edit Payment Type</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <form action="manage_payment_types.php" method="post">
                                <div class="modal-body">
                                    <input type="hidden" name="edit_payment_type" value="1">
                                    <input type="hidden" name="payment_type_id" value="<?php echo htmlspecialchars($type['id']); ?>">
                                    <div class="mb-3">
                                        <label for="payment_type_name_<?php echo htmlspecialchars($type['id']); ?>" class="form-label">Payment Type Name</label>
                                        <input type="text" class="form-control" id="payment_type_name_<?php echo htmlspecialchars($type['id']); ?>" name="payment_type_name" value="<?php echo htmlspecialchars($type['type_name']); ?>" required>
                                    </div>
                                    <div class="mb-3" id="required_amount_container_<?php echo htmlspecialchars($type['id']); ?>">
                                        <label for="required_amount_<?php echo htmlspecialchars($type['id']); ?>" class="form-label">Required Amount (<?php echo htmlspecialchars($currency_symbol); ?>)</label>
                                        <input type="number" class="form-control" id="required_amount_<?php echo htmlspecialchars($type['id']); ?>" name="required_amount" value="<?php echo htmlspecialchars($type['required_amount']); ?>" step="0.01" min="0">  <!-- Removed 'required' -->
                                        <small class="form-text text-muted">Optional (defaults to 0 if blank). Hidden for Donation/Income.</small>
                                    </div>
                                    <div class="mb-3">
                                        <label for="payment_category_<?php echo htmlspecialchars($type['id']); ?>" class="form-label">Payment Category</label>
                                        <select name="payment_category" id="payment_category_<?php echo htmlspecialchars($type['id']); ?>" class="form-select" required onchange="updateCategoryFields('<?php echo htmlspecialchars($type['id']); ?>')">
                                            <option value="recurring" <?php echo $type['payment_category'] === 'recurring' ? 'selected' : ''; ?>>Recurring</option>
                                            <option value="freewill" <?php echo $type['payment_category'] === 'freewill' ? 'selected' : ''; ?>>Freewill</option>
                                            <option value="event" <?php echo $type['payment_category'] === 'event' ? 'selected' : ''; ?>>Event</option>
                                            <option value="donation" <?php echo $type['payment_category'] === 'donation' ? 'selected' : ''; ?>>Donation</option>
                                            <!-- --- NEW OPTION ADDED --- -->
                                            <option value="other_income" <?php echo $type['payment_category'] === 'other_income' ? 'selected' : ''; ?>>Other Income</option>
                                        </select>
                                    </div>
                                    <div class="mb-3" id="recurrence_interval_container_<?php echo htmlspecialchars($type['id']); ?>" style="display: <?php echo $type['payment_category'] === 'recurring' ? 'block' : 'none'; ?>;">
                                        <label for="recurrence_interval_<?php echo htmlspecialchars($type['id']); ?>" class="form-label">Recurrence Interval</label>
                                        <select name="recurrence_interval" id="recurrence_interval_<?php echo htmlspecialchars($type['id']); ?>" class="form-select">
                                            <option value="weekly" <?php echo $type['recurrence_interval'] === 'weekly' ? 'selected' : ''; ?>>Weekly</option>
                                            <option value="monthly" <?php echo $type['recurrence_interval'] === 'monthly' ? 'selected' : ''; ?>>Monthly</option>
                                            <option value="yearly" <?php echo $type['recurrence_interval'] === 'yearly' ? 'selected' : ''; ?>>Yearly</option>
                                            <option value="none" <?php echo $type['recurrence_interval'] === 'none' || $type['recurrence_interval'] === '' ? 'selected' : ''; ?>>None</option>
                                        </select>
                                    </div>
                                    <div class="mb-3" id="event_date_container_<?php echo htmlspecialchars($type['id']); ?>" style="display: <?php echo $type['payment_category'] === 'event' ? 'block' : 'none'; ?>;">
                                        <label for="event_date_<?php echo htmlspecialchars($type['id']); ?>" class="form-label">Event Date</label>
                                        <input type="datetime-local" class="form-control" id="event_date_<?php echo htmlspecialchars($type['id']); ?>" name="event_date" value="<?php echo htmlspecialchars($type['event_date'] ? date('Y-m-d\TH:i', strtotime($type['event_date'])) : ''); ?>">
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-primary">Save Changes</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
            <!-- Modals for Editing Expense Types -->
            <?php foreach ($expense_types as $type): ?>
                <!-- ... (expense modal remains the same) ... -->
                <div class="modal fade" id="editExpenseTypeModal<?php echo htmlspecialchars($type['id']); ?>" tabindex="-1" aria-labelledby="editExpenseTypeModalLabel<?php echo htmlspecialchars($type['id']); ?>" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="editExpenseTypeModalLabel<?php echo htmlspecialchars($type['id']); ?>">Edit Expense Type</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <form action="manage_payment_types.php" method="post">
                                <div class="modal-body">
                                    <input type="hidden" name="edit_expense_type" value="1">
                                    <input type="hidden" name="expense_type_id" value="<?php echo htmlspecialchars($type['id']); ?>">
                                    <div class="mb-3">
                                        <label for="expense_type_name_<?php echo htmlspecialchars($type['id']); ?>" class="form-label">Expense Type Name</label>
                                        <input type="text" class="form-control" id="expense_type_name_<?php echo htmlspecialchars($type['id']); ?>" name="expense_type_name" value="<?php echo htmlspecialchars($type['type_name']); ?>" required>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-primary">Save Changes</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
            <!-- Modals for Editing Benefit Types -->
            <?php foreach ($benefit_types as $type): ?>
                <!-- ... (benefit modal remains the same) ... -->
                <div class="modal fade" id="editBenefitTypeModal<?php echo htmlspecialchars($type['id']); ?>" tabindex="-1" aria-labelledby="editBenefitTypeModalLabel<?php echo htmlspecialchars($type['id']); ?>" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="editBenefitTypeModalLabel<?php echo htmlspecialchars($type['id']); ?>">Edit Benefit Type</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <form action="manage_payment_types.php" method="post">
                                <div class="modal-body">
                                    <input type="hidden" name="edit_benefit_type" value="1">
                                    <input type="hidden" name="benefit_type_id" value="<?php echo htmlspecialchars($type['id']); ?>">
                                    <div class="mb-3">
                                        <label for="benefit_type_name_<?php echo htmlspecialchars($type['id']); ?>" class="form-label">Benefit Type Name</label>
                                        <input type="text" class="form-control" id="benefit_type_name_<?php echo htmlspecialchars($type['id']); ?>" name="benefit_type_name" value="<?php echo htmlspecialchars($type['type_name']); ?>" required>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-primary">Save Changes</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </main>
    </div>
</div>
<script>
function updateCategoryFields(id = '') {
    try {
        const suffix = id ? '_' + id : '';
        const categorySelect = document.getElementById('payment_category' + suffix);
        const recurrenceContainer = document.getElementById('recurrence_interval_container' + suffix);
        const eventContainer = document.getElementById('event_date_container' + suffix);
        const amountContainer = document.getElementById('required_amount_container' + suffix);
        const amountInput = document.getElementById('required_amount' + suffix);
        if (!categorySelect || !recurrenceContainer || !eventContainer || !amountContainer || !amountInput) {
            return;
        }
        const category = categorySelect.value;
        recurrenceContainer.style.display = category === 'recurring' ? 'block' : 'none';
        eventContainer.style.display = category === 'event' ? 'block' : 'none';
        const eventDateInput = document.getElementById('event_date' + suffix);
        if (eventDateInput) {
            eventDateInput.required = category === 'event';
        }
        
        // --- UPDATED JAVASCRIPT LOGIC ---
        // For 'donation' or 'other_income', hide amount field and set to 0
        if (category === 'donation' || category === 'other_income') {
            amountContainer.style.display = 'none';
            amountInput.value = 0;
        } else {
            amountContainer.style.display = 'block';
        }
    } catch (e) {
        console.error('Error in updateCategoryFields: ', e);
    }
}
document.addEventListener('DOMContentLoaded', () => {
    <?php foreach ($payment_types as $type): ?>
        updateCategoryFields('<?php echo htmlspecialchars($type['id']); ?>');
    <?php endforeach; ?>
    // Initial call for add form
    updateCategoryFields();
});
</script>
<?php require_once 'includes/footer.php'; ?>