<?php
// includes/header.php
require_once 'includes/db_config.php';
require_once 'includes/functions.php';
require_once 'includes/config/rbac.php';  // Include the RBAC config
// Get system settings
$system_name = get_setting('system_name', $link) ?? 'Club Portal';
$system_logo = get_setting('system_logo', $link) ?? 'assets/images/default_logo.png';
$header_text = get_setting('header_text', $link) ?? 'Club Management Portal';
// Centralized RBAC Check
$current_page = basename($_SERVER['PHP_SELF']);
if (isset($page_perms[$current_page])) {
    $required_perm = $page_perms[$current_page];
    if (!is_logged_in() || !user_has_permission($link, $required_perm)) {
        if (!is_logged_in()) {
            redirect('login.php');  // Redirect to login if not authenticated
        } else {
            error_log("Access denied to {$current_page}. User ID: " . ($_SESSION['user_id'] ?? 'none') . ", Role: " . ($_SESSION['user_role'] ?? 'none'));
            $dashboard = is_admin() ? 'admin_dashboard.php' : 'member_dashboard.php';
            redirect($dashboard);  // Redirect to appropriate dashboard if no permission
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($system_name); ?> - Portal</title>
    <!-- Bootstrap CSS -->
    <!-- FIXED: Ensure correct integrity attribute -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" xintegrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <!-- Custom stylesheet -->
    <link rel="stylesheet" href="assets/css/style.css">
    
    <style>
        /* --- NEW COLOR VARIABLE --- */
        :root {
            --portal-blue: #1A374D;
            --portal-green: #198754;
            --portal-orange: #f59e0b;
            --portal-orange-dark: #d97706;
            --portal-blue-hover: #406882;
        }
        /* --- NEW NAVBAR STYLES (Logo Visibility Fix) --- */
        .navbar-custom {
            background-color: var(--portal-blue);
            z-index: 1050; /* Increased Z-Index to ensure it's on top of all content */
        }
        
        /* --- MODIFIED SIDEBAR & MAIN CONTENT STYLES --- */
        .sidebar {
            position: fixed;
            top: 56px; /* Match navbar height */
            bottom: 0;
            left: 0;
            width: 250px;
            z-index: 1030; /* Higher than main content, below navbar */
            overflow-y: auto;
            transition: transform 0.3s ease-in-out;
            background-color: var(--portal-blue); 
            transform: translateX(0); /* Default state: visible */
        }
        
        /* State when collapsed (applied via JS) */
        body.sidebar-collapsed .sidebar {
            transform: translateX(-100%); /* Collapsed state: slide off screen */
        }
        .main-content {
            padding: 20px;
            padding-top: 80px; 
            transition: margin-left 0.3s ease-in-out;
            min-height: calc(100vh - 56px); 
            margin-left: 250px; /* Default state: pushed over by sidebar width */
        }
        
        /* State when collapsed (applied via JS) */
        body.sidebar-collapsed .main-content {
            margin-left: 0; /* Collapsed state: full width */
        }
        /* Mobile styles (Screen smaller than 768px) */
        @media (max-width: 767.98px) {
            .sidebar {
                /* On mobile, start collapsed by default for CSS */
                transform: translateX(-100%); 
                z-index: 1040; /* Ensure overlay on mobile */
            }
            /* When not collapsed (i.e., when body does NOT have the class), show it */
            body:not(.sidebar-collapsed) .sidebar {
                transform: translateX(0);
            }
            .main-content {
                /* On mobile, main content is always full width, regardless of sidebar state */
                margin-left: 0; 
            }
        }
        /* --- Mobile Backdrop Styles --- */
        .sidebar-backdrop {
            display: none;
            position: fixed;
            top: 56px;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 1020; /* Below sidebar */
        }
        /* --- Your other styles (unchanged) --- */
        .logo-img {
            max-width: 40px; 
            max-height: 40px; 
            object-fit: cover;
            border-radius: 50%;
        }
        .logout-btn {
            background-color: var(--portal-orange); 
            border-radius: 8px;
            padding: 8px 16px;
            font-size: 1rem;
            transition: background-color 0.3s;
            color: #fff; 
            text-decoration: none;
        }
        .logout-btn:hover {
            background-color: var(--portal-orange-dark); 
            color: #fff;
        }
        @media (max-width: 767.98px) {
            .logout-btn {
                padding: 6px 12px;
                font-size: 0.9rem;
            }
        }
        .dropdown-menu-end {
            background-color: var(--portal-orange); 
            border: none;
        }
        .dropdown-menu-end .dropdown-item {
            color: #1f2937; 
        }
        .dropdown-menu-end .dropdown-item:hover,
        .dropdown-menu-end .dropdown-item:focus {
            background-color: var(--portal-orange-dark); 
            color: #1f2937; 
        }
        .dropdown-menu-end .dropdown-divider {
            border-top: 1px solid var(--portal-orange-dark); 
            opacity: 0.5;
        }

        /* === CONSOLIDATED SIDEBAR STYLES (from sidebar.php) === */
        .sidebar .nav {
            padding-bottom: 50px; /* Excess spacing after last menu item */
        }
        .sidebar .nav-item {
            margin-bottom: 10px; /* Spacing between menu items */
        }
        .sidebar .sidebar-heading {
            font-size: 0.875rem;
        }
        .sidebar .logo-img {
            width: 80px;
            height: 80px;
        }
        .sidebar .logo-text {
            font-size: 1.25rem;
        }
        .sidebar .logout-btn {
            background-color: var(--portal-orange); /* CHANGED */
            border-radius: 10px;
            padding: 15px 25px;
            margin: 15px 20px 25px 20px;
            font-size: 1.1rem;
            transition: background-color 0.3s;
            color: #fff; /* Added for high contrast */
        }
        .sidebar .logout-btn:hover {
            background-color: var(--portal-orange-dark); /* CHANGED */
            color: #fff; /* Added for high contrast */
        }
        .sidebar .logout-container {
            padding-bottom: 20px; /* Additional spacing after logout button */
        }
        .sidebar .submenu-collapse {
            padding-left: 20px; /* Indent submenu items */
            background-color: rgba(0,0,0,0.2); /* CHANGED - Darkens the blue */
            border-radius: 5px;
            margin-top: -5px;
            margin-bottom: 5px;
        }
        .sidebar .submenu-collapse .nav-item {
            margin-bottom: 5px; /* Tighter spacing for submenu */
        }
        .sidebar .submenu-collapse .nav-link {
            font-size: 0.9rem; /* Smaller font for submenu */
            padding-top: 0.5rem;
            padding-bottom: 0.5rem;
        }
        .sidebar .collapse-toggle {
            display: flex;
            align-items: center;
        }
        .sidebar .collapse-toggle .rotate {
            transition: transform 0.3s ease;
        }
        .sidebar .collapse-toggle[aria-expanded="true"] .rotate {
            transform: rotate(180deg);
        }
        .sidebar .nav-link.active,
        .sidebar .collapse-toggle[aria-expanded="true"] {
            font-weight: bold;
            background-color: var(--portal-green); /* CHANGED to green */
            border-radius: 5px;
            color: #fff;
        }
        .sidebar .submenu-collapse .nav-link.active {
            background-color: var(--portal-green); /* CHANGED to green */
            color: #fff;
        }
        .sidebar .nav-link.text-white:not(.active):not(.collapse-toggle[aria-expanded="true"]):hover {
            background-color: var(--portal-blue-hover); /* NEW blue hover */
            border-radius: 5px;
            color: #fff;
        }

        /* === NEW FOOTER STYLE === */
        .footer-custom {
            background-color: var(--portal-blue);
            color: #fff;
        }
        .footer-custom a {
            color: #fff;
            text-decoration: none;
        }
        .footer-custom a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body class="d-flex flex-column min-vh-100"> 
    <!-- Top Navigation Bar -->
    <nav class="navbar navbar-expand-md navbar-dark navbar-custom fixed-top"> 
        <div class="container-fluid">
            <!-- Sidebar toggle button - Initial icon is the collapse arrow (fa-angle-double-left) -->
            <button class="btn btn-dark me-2" type="button" id="sidebarToggle" aria-label="Toggle sidebar">
                <i class="fas fa-angle-double-left"></i>
            </button>
            <a class="navbar-brand me-auto" href="member_dashboard.php">
                <img src="<?php echo htmlspecialchars($system_logo); ?>" alt="Club Logo" class="logo-img me-2">
                <?php echo htmlspecialchars($header_text); ?>
            </a>
            <?php if (is_logged_in()): ?>
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle logout-btn" href="#" id="userDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fas fa-user me-2"></i><?php echo htmlspecialchars($_SESSION['user_name'] ?? 'User'); ?>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
                            <li><a class="dropdown-item" href="profile.php">Profile</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="logout.php"><i class="fas fa-sign-out-alt me-2"></i>Logout</a></li>
                        </ul>
                    </li>
                </ul>
            <?php endif; ?>
        </div>
    </nav>
    <?php include_global_scripts(); ?>
    
    <br><br><br>