// includes/global.js

/**
 * Prints a card's table content in a new window with a custom report format.
 * @param {string} cardId The ID of the card containing the table to print.
 */
function printCardContent(cardId) {
    const card = document.getElementById(cardId);
    if (!card) {
        console.error('Card with ID ' + cardId + ' not found.');
        alert('Error: Table not found.');
        return;
    }
    
    const table = card.querySelector('table');
    if (!table) {
        console.error('Table not found within card ' + cardId);
        alert('Error: No table data to print.');
        return;
    }

    const titleElement = card.querySelector('.card-header span');
    const tableName = titleElement ? titleElement.textContent.trim() : cardId;

    const newWin = window.open('', '_blank', 'width=800,height=600');
    if (!newWin) {
        alert('Please allow pop-ups for this website to enable printing.');
        return;
    }

    newWin.document.write(`
        <html>
            <head>
                <title>Print Report - ${tableName}</title>
                <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
                <style>
                    body { font-family: Arial, sans-serif; margin: 20px; }
                    .table-responsive { overflow-x: visible !important; }
                    table { width: 100%; border-collapse: collapse; font-size: 12px; }
                    th, td { padding: 8px; border: 1px solid #dee2e6; }
                    th { background-color: #f8f9fa; font-weight: bold; }
                    h2 { text-align: center; margin-bottom: 20px; }
                    @media print {
                        .no-print { display: none; }
                    }
                </style>
            </head>
            <body>
                <h2>${tableName} Report</h2>
                <div class="table-responsive">
                    ${table.outerHTML}
                </div>
                <script>
                    window.onload = function() {
                        try {
                            window.print();
                            setTimeout(() => window.close(), 1000);
                        } catch (e) {
                            console.error('Print error:', e);
                            alert('An error occurred while printing.');
                        }
                    };
                </script>
            </body>
        </html>
    `);
    newWin.document.close();
}