<?php
require_once 'includes/functions.php';
require_once 'includes/db_config.php';
session_start();

// Set JSON content type
header('Content-Type: application/json');

// Check if user is logged in
if (!is_logged_in()) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized access.']);
    exit;
}

$user_id = $_SESSION['user_id'];

// Fetch form data for the user
$sql = "SELECT 
            fd.id AS form_data_id,
            fd.form_id,
            fd.data AS form_data,
            fd.created_at,
            f.form_data AS form_structure
        FROM form_data fd
        LEFT JOIN forms f ON fd.form_id = f.id
        WHERE fd.user_id = ?
        ORDER BY fd.created_at DESC";
$stmt = mysqli_prepare($link, $sql);
mysqli_stmt_bind_param($stmt, "i", $user_id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

$forms = [];
while ($row = mysqli_fetch_assoc($result)) {
    $forms[] = [
        'form_data_id' => $row['form_data_id'],
        'form_id' => $row['form_id'],
        'form_data' => json_decode($row['form_data'], true),
        'form_structure' => json_decode($row['form_structure'], true),
        'created_at' => $row['created_at']
    ];
}
mysqli_stmt_close($stmt);

if (empty($forms)) {
    echo json_encode(['success' => false, 'message' => 'No form data found for this user.']);
} else {
    echo json_encode(['success' => true, 'forms' => $forms]);
}
?>