<?php
// This file simulates a database query to get financial summary data.

// Set the response header to JSON format
header('Content-Type: application/json');

// This is where you would put your actual database connection logic.
// For example:
// require_once 'database_connection.php';
// $conn = get_database_connection();

// This is a placeholder for your database query results.
// Replace this with your actual PHP logic to query your database.
$totalPaid = 1545000.00; // Example data from a database query
$paidThisMonth = 250000.00; // Example data
$outstandingDebtors = 50; // Example data

// Prepare the data to be sent back as JSON
$response = [
    'success' => true,
    'summary' => [
        'total_paid' => number_format($totalPaid, 2),
        'paid_this_month' => number_format($paidThisMonth, 2),
        'outstanding_debtors' => $outstandingDebtors,
    ],
    'message' => 'Financial summary retrieved successfully.'
];

// Send the JSON response
echo json_encode($response);

?>
