<?php
// admin_dashboard.php
require_once 'includes/functions.php';
require_once 'includes/db_config.php';
session_start();
// Check if user is logged in and has admin role
if (!is_logged_in() || $_SESSION['user_role'] !== 'admin') {
    if (is_logged_in() && $_SESSION['user_role'] === 'super_admin') {
        redirect("super_admin_dashboard.php");
    } else {
        redirect("login.php");
    }
}
// Session timeout
$timeout = 1800; // 30 minutes
if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity']) > $timeout) {
    session_unset();
    session_destroy();
    redirect("login.php?timeout=1");
}
$_SESSION['last_activity'] = time();
$system_name = get_setting('system_name', $link) ?? 'Club Portal';
$currency_symbol = get_setting('currency_symbol', $link) ?? '₦';
$username = $_SESSION['user_name'] ?? 'Admin';
$current_datetime = date('l, F j, Y');
// Initialize variables
$total_members = 0;
$total_tokens_purchased = 0;
$my_tokens = 0;
$other_admins_tokens = 0;
$accountant_tokens = 0;
$organization_total_tokens = 0;
$total_tokens_used = 0;
// Fetch total members (if permitted)
if (user_has_permission($link, 'view_member_directory')) {
    $sql_members = "SELECT COUNT(*) AS total FROM users WHERE role IN ('member', 'pending')";
    $result_members = mysqli_query($link, $sql_members);
    if ($result_members) {
        $row = mysqli_fetch_assoc($result_members);
        $total_members = $row['total'];
        mysqli_free_result($result_members);
    } else {
        error_log("Failed to fetch members: " . mysqli_error($link));
    }
}
// Total tokens purchased (approved only)
$sql = "SELECT COALESCE(SUM(quantity), 0) AS total FROM token_purchases WHERE status = 'approved'";
$result = mysqli_query($link, $sql);
if ($result) {
    $total_tokens_purchased = mysqli_fetch_assoc($result)['total'] ?? 0;
    mysqli_free_result($result);
} else {
    error_log("Failed to fetch tokens purchased: " . mysqli_error($link));
}
// MY tokens (current admin)
$my_tokens = get_user_token_balance($link, $_SESSION['user_id']);
// ACCOUNTANT tokens
$sql = "SELECT COALESCE(SUM(balance), 0) AS total FROM token_balances tb JOIN users u ON tb.user_id = u.id WHERE u.role = 'accountant' AND u.deleted_at IS NULL AND tb.balance > 0";
$result = mysqli_query($link, $sql);
if ($result) {
    $accountant_tokens = mysqli_fetch_assoc($result)['total'] ?? 0;
    mysqli_free_result($result);
} else {
    error_log("Failed to fetch accountant tokens: " . mysqli_error($link));
}
// OTHER ADMINS tokens (all admins except current user)
$current_user_id = $_SESSION['user_id'];
$sql = "SELECT COALESCE(SUM(tb.balance), 0) AS total 
        FROM token_balances tb 
        JOIN users u ON tb.user_id = u.id 
        WHERE u.role = 'admin' AND u.id != ? AND u.deleted_at IS NULL AND tb.balance > 0";
$stmt = mysqli_prepare($link, $sql);
if ($stmt) {
    mysqli_stmt_bind_param($stmt, "i", $current_user_id);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $row = mysqli_fetch_assoc($result);
    $other_admins_tokens = $row['total'] ?? 0;
    mysqli_stmt_close($stmt);
} else {
    error_log("Failed to prepare other admins tokens query: " . mysqli_error($link));
}
// ORGANIZATION TOTAL tokens (My + Other Admins + Accountant)
$organization_total_tokens = $my_tokens + $other_admins_tokens + $accountant_tokens;
// Total tokens used
$sql = "SELECT COALESCE(SUM(tokens_used), 0) AS total FROM token_usage_logs";
$result = mysqli_query($link, $sql);
if ($result) {
    $total_tokens_used = mysqli_fetch_assoc($result)['total'] ?? 0;
    mysqli_free_result($result);
} else {
    error_log("Failed to fetch tokens used: " . mysqli_error($link));
}
?>
<?php require_once 'includes/header.php'; ?>
<script>
document.title = 'Admin Dashboard - <?php echo htmlspecialchars($system_name); ?>';
</script>
<style>
    .welcome-message {
        background: #f8f9fa;
        padding: 20px;
        border-radius: 10px;
        text-align: center;
        margin-bottom: 20px;
        overflow: hidden;
        position: relative;
    }
    .scrolling-text {
        white-space: nowrap;
        display: inline-block;
        animation: scrollLeft 30s linear infinite;
        padding-left: 100%;
        color: #1a2a44;
        background-color: #f4a261;
        font-size: 1.8rem;
        padding: 5px 10px;
    }
    .scrolling-text:hover {
        animation-play-state: paused;
    }
    @keyframes scrollLeft {
        0% { transform: translateX(100%); }
        100% { transform: translateX(-100%); }
    }
    .main-content {
        padding: 20px;
    }
    .card {
        border: none;
        border-radius: 15px;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        transition: transform 0.3s, box-shadow 0.3s;
    }
    .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 16px rgba(0, 0, 0, 0.2);
    }
    .card-icon {
        font-size: 2.5rem;
        color: #ffffff;
        background-color: #007bff;
        padding: 15px;
        border-radius: 50%;
    }
    .card-title {
        font-size: 1.2rem;
        font-weight: bold;
    }
    .card-text {
        font-size: 1.5rem;
        font-weight: bold;
        color: #333;
    }
    .org-total-card {
        background: linear-gradient(135deg, #28a745, #20c997);
    }
    .org-total-card .card-text {
        color: white !important;
        font-size: 1.8rem;
    }
    .org-total-card .card-title {
        color: white;
    }
</style>
<div class="container-fluid">
    <div class="row">
        <?php require_once 'includes/sidebar.php'; ?>
        <main class="col-md-9 col-lg-10 main-content">
            <h2>Admin Dashboard</h2>
            <hr>
            <!-- Welcome Message -->
            <div class="welcome-message">
                <div class="scrolling-text">
                    Welcome, <?php echo htmlspecialchars($username); ?>! Today is <?php echo $current_datetime; ?>. Transform Your Association into a Transparent, Trusted, and Organized System

ASSOTRACK is not just another management software —
it’s the heartbeat of transparent leadership, financial accountability, and member confidence.
                </div>
            </div>
            <!-- Token Balances Overview -->
            <div class="row g-4 mb-4">
                <!-- My Tokens -->
                <div class="col-md-4 col-lg-3">
                    <div class="card bg-light">
                        <div class="card-body text-center">
                            <i class="fas fa-user-shield card-icon" style="background-color: #6f42c1;"></i>
                            <h5 class="card-title mt-3">My Tokens</h5>
                            <p class="card-text"><?php echo htmlspecialchars($my_tokens); ?></p>
                        </div>
                    </div>
                </div>
                <!-- Other Admins Tokens -->
                <div class="col-md-4 col-lg-3">
                    <div class="card bg-light">
                        <div class="card-body text-center">
                            <i class="fas fa-users-cog card-icon" style="background-color: #fd7e14;"></i>
                            <h5 class="card-title mt-3">Other Admin Tokens</h5>
                            <p class="card-text"><?php echo htmlspecialchars($other_admins_tokens); ?></p>
                        </div>
                    </div>
                </div>
                <!-- Accountant Tokens -->
                <div class="col-md-4 col-lg-3">
                    <div class="card bg-light">
                        <div class="card-body text-center">
                            <i class="fas fa-calculator card-icon" style="background-color: #20c997;"></i>
                            <h5 class="card-title mt-3">Accountant Token</h5>
                            <p class="card-text"><?php echo htmlspecialchars($accountant_tokens); ?></p>
                        </div>
                    </div>
                </div>
                <!-- Organization Total -->
                <div class="col-md-4 col-lg-3">
                    <div class="card org-total-card">
                        <div class="card-body text-center">
                            <i class="fas fa-university card-icon"></i>
                            <h5 class="card-title mt-3">Organization Token Balance</h5>
                            <p class="card-text"><?php echo htmlspecialchars($organization_total_tokens); ?></p>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Other Metrics Overview -->
            <div class="row g-4 mb-4">
                <!-- Total Members Card -->
                <div class="col-md-4 col-lg-3">
                    <div class="card bg-light">
                        <div class="card-body text-center">
                            <i class="fas fa-users card-icon"></i>
                            <h5 class="card-title mt-3">Total Members</h5>
                            <p class="card-text"><?php echo htmlspecialchars($total_members); ?></p>
                        </div>
                    </div>
                </div>
                <!-- Total Tokens Purchased Card -->
                <div class="col-md-4 col-lg-3">
                    <div class="card bg-light">
                        <div class="card-body text-center">
                            <i class="fas fa-coins card-icon" style="background-color: #28a745;"></i>
                            <h5 class="card-title mt-3">Total Tokens Purchased</h5>
                            <p class="card-text"><?php echo htmlspecialchars($total_tokens_purchased); ?></p>
                        </div>
                    </div>
                </div>
                <!-- Total Tokens Used Card -->
                <div class="col-md-4 col-lg-3">
                    <div class="card bg-light">
                        <div class="card-body text-center">
                            <i class="fas fa-hand-holding-usd card-icon" style="background-color: #dc3545;"></i>
                            <h5 class="card-title mt-3">Total Tokens Used</h5>
                            <p class="card-text"><?php echo htmlspecialchars($total_tokens_used); ?></p>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Quick Actions Section -->
            <?php if (user_has_permission($link, 'view_payments') || user_has_permission($link, 'view_member_directory') || user_has_permission($link, 'view_debts') || user_has_permission($link, 'view_benefits') || user_has_permission($link, 'manage_members') || user_has_permission($link, 'manage_news') || user_has_permission($link, 'manage_messages') || user_has_permission($link, 'manage_forms') || user_has_permission($link, 'view_settings')): ?>
                <div class="card mb-4">
                    <div class="card-header">Quick Actions</div>
                    <div class="card-body">
                        <div class="d-flex flex-wrap gap-2">
                            <?php if (user_has_permission($link, 'view_payments')): ?>
                                <a href="manage_payment_types.php" class="btn btn-outline-primary"><i class="fas fa-money-bill-wave me-2"></i>Manage Payments</a>
                            <?php endif; ?>
                            <?php if (user_has_permission($link, 'view_member_directory')): ?>
                                <a href="member_directory.php" class="btn btn-outline-primary"><i class="fas fa-users me-2"></i>View Member Directory</a>
                            <?php endif; ?>
                            <?php if (user_has_permission($link, 'view_debts')): ?>
                                <a href="manage_payment_types.php" class="btn btn-outline-primary"><i class="fas fa-money-bill-alt me-2"></i>Manage Debts</a>
                            <?php endif; ?>
                            <?php if (user_has_permission($link, 'view_benefits')): ?>
                                <a href="manage_payment_types.php" class="btn btn-outline-primary"><i class="fas fa-gift me-2"></i>Manage Benefits</a>
                            <?php endif; ?>
                            <?php if (user_has_permission($link, 'manage_members')): ?>
                                <a href="member_management.php" class="btn btn-outline-primary"><i class="fas fa-users-cog me-2"></i>Manage Members</a>
                            <?php endif; ?>
                            <?php if (user_has_permission($link, 'manage_news')): ?>
                                <a href="announcement_management.php" class="btn btn-outline-primary"><i class="fas fa-bullhorn me-2"></i>Manage Announcements</a>
                            <?php endif; ?>
                            <?php if (user_has_permission($link, 'manage_messages')): ?>
                                <a href="messages_admin.php" class="btn btn-outline-primary"><i class="fas fa-envelope me-2"></i>Manage Messages</a>
                            <?php endif; ?>
                            <?php if (user_has_permission($link, 'manage_forms')): ?>
                                <a href="form_builder.php" class="btn btn-outline-primary"><i class="fas fa-cogs me-2"></i>Form Builder</a>
                            <?php endif; ?>
                            <?php if (user_has_permission($link, 'view_settings')): ?>
                                <a href="admin_settings.php" class="btn btn-outline-primary"><i class="fas fa-cogs me-2"></i>Admin Settings</a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </main>
    </div>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // No JavaScript required for this version
});
</script>
<?php require_once 'includes/footer.php'; ?>