<?php
/* --------------------------------------------------------------
   templates/financial_summary_template.php
   -------------------------------------------------------------- */
$tables = ['payments', 'expenses', 'debts', 'benefits'];
require_once 'includes/header.php';

/* Safe fall-backs for dropdowns (in case the function returns nothing) */
$type_options_payments = $type_options_payments ?? '<option value="">All Payment Types</option>';
$type_options_expenses = $type_options_expenses ?? '<option value="">All Expense Types</option>';
$type_options_benefits = $type_options_benefits ?? '<option value="">All Benefit Types</option>';
?>
<script>
document.title = 'Financial Summary - <?php echo htmlspecialchars($system_name); ?>';
</script>

<style>
/* (unchanged – your original CSS) */
.main-content { padding: 20px; }
.card { transition: transform .2s, box-shadow .2s; border:none; border-radius:10px; }
.card:hover { transform:translateY(-5px); box-shadow:0 4px 20px rgba(0,0,0,.1); }
.card-header { font-weight:bold; border-bottom:none; }
.table-responsive { max-height:500px; overflow-y:auto; }
.filter-section { background:#f8f9fa; padding:15px; border-radius:10px; }
.no-data { font-style:italic; color:#6c757d; }
@media print{
    body *{visibility:hidden;}
    .print-card,.print-card *,#dashboardCards,#dashboardCards *{visibility:visible;}
    .print-card,#dashboardCards{position:static;width:100%;page-break-inside:avoid;}
    .no-print{display:none !important;}
    table{border-collapse:collapse;width:100%;}
    th,td{border:1px solid #ddd;padding:8px;text-align:left;}
    th{background:#f2f2f2;font-weight:bold;}
    .card{border:none;box-shadow:none;}
}
</style>

<div class="container-fluid">
    <div class="row">
        <?php require_once 'includes/sidebar.php'; ?>
        <main class="col-md-9 col-lg-10 main-content">
            <h2>Financial Summary</h2><hr>

            <!-- ==================== CARDS ==================== -->
            <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-lg-4 mb-4" id="dashboardCards">
                <?php if (user_has_permission($link, 'view_payments')): ?>
                    <div class="col mb-3">
                        <div class="card text-white bg-success">
                            <div class="card-header">Total Payments</div>
                            <div class="card-body">
                                <h5><?php echo format_currency($total_payments, $currency_symbol); ?></h5>
                                <small class="text-<?php echo $payment_change > 0 ? 'success' : 'danger'; ?>">
                                    <?php echo format_currency(abs($payment_change), $currency_symbol); ?>
                                    <i class="fas fa-arrow-<?php echo $payment_change > 0 ? 'up' : 'down'; ?>"></i> from last month
                                </small>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if (user_has_permission($link, 'view_expenses')): ?>
                    <div class="col mb-3">
                        <div class="card text-white bg-danger">
                            <div class="card-header">Total Expenses</div>
                            <div class="card-body">
                                <h5><?php echo format_currency($total_expenses, $currency_symbol); ?></h5>
                                <small class="text-<?php echo $expenses_change > 0 ? 'success' : 'danger'; ?>">
                                    <?php echo format_currency(abs($expenses_change), $currency_symbol); ?>
                                    <i class="fas fa-arrow-<?php echo $expenses_change > 0 ? 'up' : 'down'; ?>"></i> from last month
                                </small>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if (user_has_permission($link, 'view_benefits')): ?>
                    <div class="col mb-3">
                        <div class="card text-white bg-primary">
                            <div class="card-header">Total Benefits</div>
                            <div class="card-body">
                                <h5><?php echo format_currency($total_benefits, $currency_symbol); ?></h5>
                                <small class="text-<?php echo $benefits_change > 0 ? 'success' : 'danger'; ?>">
                                    <?php echo format_currency(abs($benefits_change), $currency_symbol); ?>
                                    <i class="fas fa-arrow-<?php echo $benefits_change > 0 ? 'up' : 'down'; ?>"></i> from last month
                                </small>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if (user_has_permission($link, 'view_debts')): ?>
                    <div class="col mb-3">
                        <div class="card text-white bg-warning">
                            <div class="card-header">Total Debts</div>
                            <div class="card-body">
                                <h5><?php echo format_currency($total_debts, $currency_symbol); ?></h5>
                                <small class="text-<?php echo $debts_change > 0 ? 'success' : 'danger'; ?>">
                                    <?php echo format_currency(abs($debts_change), $currency_symbol); ?>
                                    <i class="fas fa-arrow-<?php echo $debts_change > 0 ? 'up' : 'down'; ?>"></i> from last month
                                </small>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <div class="col mb-3">
                    <div class="card text-white bg-dark">
                        <div class="card-header">Current Balance</div>
                        <div class="card-body">
                            <h5><?php echo format_currency($current_balance, $currency_symbol); ?></h5>
                        </div>
                    </div>
                </div>

                <?php if ($total_excess_donations > 0 && user_has_permission($link, 'view_payments')): ?>
                    <div class="col mb-3">
                        <div class="card text-white bg-info">
                            <div class="card-header">Total Excess Donations</div>
                            <div class="card-body">
                                <h5><?php echo format_currency($total_excess_donations, $currency_symbol); ?></h5>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <div class="col mb-3">
                    <div class="card text-white bg-info">
                        <div class="card-header">Previous Month Balance</div>
                        <div class="card-body">
                            <h5>
                                <?php echo ($prev_balances['month'] !== null && $prev_balances['month'] != 0)
                                    ? format_currency($prev_balances['month'], $currency_symbol)
                                    : '<span class="no-data">No transactions</span>'; ?>
                            </h5>
                        </div>
                    </div>
                </div>

                <div class="col mb-3">
                    <div class="card text-white bg-primary">
                        <div class="card-header">Previous Year Balance</div>
                        <div class="card-body">
                            <h5>
                                <?php echo ($prev_balances['year'] !== null && $prev_balances['year'] != 0)
                                    ? format_currency($prev_balances['year'], $currency_symbol)
                                    : '<span class="no-data">No transactions</span>'; ?>
                            </h5>
                        </div>
                    </div>
                </div>
            </div>

            <!-- ==================== PRINT / AUDIT ==================== -->
            <?php if ($is_admin): ?>
                <div class="mb-4">
                    <button class="btn btn-outline-secondary" onclick="printDashboard()">Print Dashboard</button>
                    <a href="audit_log.php" class="btn btn-outline-secondary">Audit Log</a>
                </div>
            <?php endif; ?>

            <!-- ==================== FILTERS ==================== -->
            <div class="mb-4 filter-section">
                <form id="filterForm" method="GET">
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <label class="form-label">Record Type:</label>
                            <select name="record_type" class="form-select">
                                <option value="all" <?php echo $record_type==='all'?'selected':''; ?>>All</option>
                                <option value="payments" <?php echo $record_type==='payments'?'selected':''; ?>>Payments</option>
                                <option value="expenses" <?php echo $record_type==='expenses'?'selected':''; ?>>Expenses</option>
                                <option value="benefits" <?php echo $record_type==='benefits'?'selected':''; ?>>Benefits</option>
                                <option value="debts" <?php echo $record_type==='debts'?'selected':''; ?>>Debts</option>
                            </select>
                        </div>

                        <div class="col-md-3 mb-3">
                            <label class="form-label">Time Period:</label>
                            <select name="time_period" class="form-select" onchange="toggleDatePicker()">
                                <option value="all" <?php echo $time_period==='all'?'selected':''; ?>>All Time</option>
                                <option value="range" <?php echo $time_period==='range'?'selected':''; ?>>Custom Range</option>
                                <option value="week" <?php echo $time_period==='week'?'selected':''; ?>>Last Week</option>
                                <option value="month" <?php echo $time_period==='month'?'selected':''; ?>>Last Month</option>
                                <option value="year" <?php echo $time_period==='year'?'selected':''; ?>>Last Year</option>
                            </select>
                        </div>

                        <div class="col-md-3 mb-3" id="datePickerContainer" style="display:<?php echo $time_period==='range'?'block':'none'; ?>;">
                            <label class="form-label">Start Date:</label>
                            <input type="date" name="start_date" class="form-control" value="<?php echo $start_date; ?>">
                            <label class="form-label mt-2">End Date:</label>
                            <input type="date" name="end_date" class="form-control" value="<?php echo $end_date; ?>">
                        </div>

                        <!-- TYPE FILTERS -->
                        <div class="col-md-3 mb-3">
                            <label class="form-label">Payment Type:</label>
                            <select name="type_filter_payments" class="form-select">
                                <option value="">All Payment Types</option>
                                <?php echo $type_options_payments; ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label class="form-label">Expense Type:</label>
                            <select name="type_filter_expenses" class="form-select">
                                <option value="">All Expense Types</option>
                                <?php echo $type_options_expenses; ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label class="form-label">Benefit Type:</label>
                            <select name="type_filter_benefits" class="form-select">
                                <option value="">All Benefit Types</option>
                                <?php echo $type_options_benefits; ?>
                            </select>
                        </div>

                        <div class="col-md-3 mb-3">
                            <label class="form-label">Member:</label>
                            <select name="member_id" class="form-select">
                                <option value="0">All Members</option>
                                <?php foreach ($members as $m): ?>
                                    <option value="<?php echo $m['id']; ?>" <?php echo $member_id==$m['id']?'selected':''; ?>>
                                        <?php echo htmlspecialchars($m['full_name']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="col-md-3 mb-3">
                            <label class="form-label">Date Field (Debts):</label>
                            <select name="date_field" class="form-select">
                                <option value="created_at" <?php echo $date_field==='created_at'?'selected':''; ?>>Created At</option>
                                <option value="due_date" <?php echo $date_field==='due_date'?'selected':''; ?>>Due Date</option>
                            </select>
                        </div>

                        <div class="col-md-3 mb-3">
                            <label class="form-label">Search:</label>
                            <input type="text" name="search" class="form-control" value="<?php echo htmlspecialchars($search); ?>">
                        </div>

                        <div class="col-md-3 mb-3 d-flex align-items-end">
                            <button type="submit" class="btn btn-primary me-2">Apply</button>
                            <button type="button" class="btn btn-secondary" onclick="resetFilters()">Reset</button>
                        </div>

                        <!-- hidden pagination fields -->
                        <?php foreach ($tables as $t): ?>
                            <input type="hidden" name="page_<?php echo $t; ?>" value="<?php echo $pagination[$t]['page']; ?>">
                            <input type="hidden" name="per_page_<?php echo $t; ?>" value="<?php echo $pagination[$t]['per_page']; ?>">
                        <?php endforeach; ?>
                    </div>
                </form>
            </div>

            <!-- ==================== CHARTS ==================== -->
            <?php if (user_has_permission($link, 'view_payments') || user_has_permission($link, 'view_expenses')
                      || user_has_permission($link, 'view_benefits') || user_has_permission($link, 'view_debts')): ?>
                <div class="card mb-4">
                    <div class="card-header">Financial Breakdown (Bar)</div>
                    <div class="card-body"><canvas id="financialBarChart" height="100"></canvas></div>
                </div>

                <div class="row mb-4">
                    <div class="col-md-4 mb-3">
                        <div class="card">
                            <div class="card-header">Overview (Pie)</div>
                            <div class="card-body"><canvas id="financialPieChart" height="200"></canvas></div>
                        </div>
                    </div>
                    <div class="col-md-4 mb-3">
                        <div class="card">
                            <div class="card-header">By Type (Histogram)</div>
                            <div class="card-body"><canvas id="financialHistogram" height="200"></canvas></div>
                        </div>
                    </div>
                    <div class="col-md-4 mb-3">
                        <div class="card">
                            <div class="card-header">Trend (Line)</div>
                            <div class="card-body"><canvas id="financialLineChart" height="200"></canvas></div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <!-- ==================== SUMMARIES ==================== -->
            <?php
            $summaries = [
                ['title'=>'Payment Types Summary','data'=>$payment_types_summary ?? [],'table'=>'payments'],
                ['title'=>'Expense Types Summary','data'=>$expense_types_summary ?? [],'table'=>'expenses'],
                ['title'=>'Benefit Types Summary','data'=>$benefit_types_summary ?? [],'table'=>'benefits']
            ];
            foreach ($summaries as $s):
                if (($record_type==='all' || $record_type===$s['table']) && $s['data']): ?>
                    <div class="card mb-4 print-card">
                        <div class="card-header"><?php echo htmlspecialchars($s['title']); ?></div>
                        <div class="card-body table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Type Name</th>
                                        <?php if ($s['title']==='Payment Types Summary'): ?>
                                            <th>Required</th><th>Total Paid</th><th>Total Debt</th><th>Excess</th>
                                        <?php else: ?>
                                            <th>Total</th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($s['data'] as $row): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($row['type_name']); ?></td>
                                            <?php if ($s['title']==='Payment Types Summary'): ?>
                                                <td><?php echo format_currency($row['required_amount'], $currency_symbol); ?></td>
                                                <td><?php echo format_currency($row['total_paid'], $currency_symbol); ?></td>
                                                <td><?php echo format_currency($row['total_debt'], $currency_symbol); ?></td>
                                                <td><?php echo format_currency($row['excess_amount'], $currency_symbol); ?></td>
                                            <?php else: ?>
                                                <td><?php echo format_currency($row['total'], $currency_symbol); ?></td>
                                            <?php endif; ?>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                <?php endif;
            endforeach; ?>

            <!-- ==================== TABLES ==================== -->
            <?php
            $tableInfo = [
                ['title'=>'Payments','data'=>$payments,'table'=>'payments','cnt'=>$total_counts['payments']],
                ['title'=>'Expenses','data'=>$expenses,'table'=>'expenses','cnt'=>$total_counts['expenses']],
                ['title'=>'Benefits','data'=>$benefits,'table'=>'benefits','cnt'=>$total_counts['benefits']],
                ['title'=>'Debts','data'=>$debts,'table'=>'debts','cnt'=>$total_counts['debts']]
            ];
            foreach ($tableInfo as $ti):
                if ($record_type!=='all' && $record_type!==$ti['table']) continue; ?>
                    <div class="card mb-4 print-card">
                        <div class="card-header"><?php echo htmlspecialchars($ti['title']); ?> (Total: <?php echo $ti['cnt']; ?>)</div>
                        <div class="card-body table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <?php if ($ti['title']==='Payments'): ?>
                                            <th>ID</th><th>Full Name</th><th>Payment Type</th><th>Amount</th><th>Status</th><th>Created At</th><th>Payment Cycle</th>
                                            <?php if ($is_admin): ?><th class="no-print">Actions</th><?php endif; ?>
                                        <?php elseif ($ti['title']==='Expenses'): ?>
                                            <th>ID</th><th>Expense Type</th><th>Amount</th><th>Description</th><th>Created At</th>
                                        <?php elseif ($ti['title']==='Benefits'): ?>
                                            <th>ID</th><th>Member ID</th><th>Full Name</th><th>Benefit Type</th><th>Amount</th><th>Created At</th>
                                            <?php if ($is_admin): ?><th class="no-print">Actions</th><?php endif; ?>
                                        <?php elseif ($ti['title']==='Debts'): ?>
                                            <th>Member ID</th><th>Full Name</th><th>Payment Type</th><th>Required</th><th>Total Paid</th><th>Debt</th><th>Payment Cycle</th><th>Due Date</th>
                                            <?php if ($is_admin): ?><th class="no-print">Actions</th><?php endif; ?>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($ti['data'] as $row): ?>
                                        <tr>
                                            <?php if ($ti['title']==='Payments'): ?>
                                                <td><?php echo $row['id']; ?></td>
                                                <td><?php echo htmlspecialchars($row['full_name']); ?></td>
                                                <td><?php echo htmlspecialchars($row['payment_type']); ?></td>
                                                <td><?php echo format_currency($row['amount'], $currency_symbol); ?></td>
                                                <td><?php echo htmlspecialchars($row['payment_status']); ?></td>
                                                <td><?php echo date('Y-m-d', strtotime($row['created_at'])); ?></td>
                                                <td><?php echo htmlspecialchars($row['payment_cycle'] ?? 'N/A'); ?></td>
                                                <?php if ($is_admin): ?>
                                                    <td class="no-print">
                                                        <a href="edit_payment.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-outline-primary">Edit</a>
                                                        <a href="delete_payment.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Delete?');">Delete</a>
                                                    </td>
                                                <?php endif; ?>
                                            <?php elseif ($ti['title']==='Expenses'): ?>
                                                <td><?php echo $row['id']; ?></td>
                                                <td><?php echo htmlspecialchars($row['expense_type'] ?? 'N/A'); ?></td>
                                                <td><?php echo format_currency($row['amount'], $currency_symbol); ?></td>
                                                <td><?php echo htmlspecialchars($row['description']); ?></td>
                                                <td><?php echo date('Y-m-d', strtotime($row['created_at'])); ?></td>
                                            <?php elseif ($ti['title']==='Benefits'): ?>
                                                <td><?php echo $row['id']; ?></td>
                                                <td><?php echo $row['member_id']; ?></td>
                                                <td><?php echo htmlspecialchars($row['full_name']); ?></td>
                                                <td><?php echo htmlspecialchars($row['benefit_type']); ?></td>
                                                <td><?php echo format_currency($row['amount'], $currency_symbol); ?></td>
                                                <td><?php echo date('Y-m-d', strtotime($row['created_at'])); ?></td>
                                                <?php if ($is_admin): ?>
                                                    <td class="no-print">
                                                        <a href="edit_benefit.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-outline-primary">Edit</a>
                                                        <a href="delete_benefit.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Delete?');">Delete</a>
                                                    </td>
                                                <?php endif; ?>
                                            <?php elseif ($ti['title']==='Debts'): ?>
                                                <td><?php echo $row['member_id']; ?></td>
                                                <td><?php echo htmlspecialchars($row['full_name']); ?></td>
                                                <td><?php echo htmlspecialchars($row['payment_type']); ?></td>
                                                <td><?php echo format_currency($row['required_amount'], $currency_symbol); ?></td>
                                                <td><?php echo format_currency($row['total_paid'], $currency_symbol); ?></td>
                                                <td><?php echo format_currency($row['debt'], $currency_symbol); ?></td>
                                                <td><?php echo htmlspecialchars($row['payment_cycle'] ?? 'N/A'); ?></td>
                                                <td><?php echo htmlspecialchars($row['due_date'] ?? 'N/A'); ?></td>
                                                <?php if ($is_admin): ?>
                                                    <td class="no-print">
                                                        <a href="edit_member.php?id=<?php echo $row['user_id']; ?>" class="btn btn-sm btn-outline-primary">Edit</a>
                                                    </td>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <nav aria-label="Page navigation">
                            <ul class="pagination">
                                <?php if ($pagination[$ti['table']]['page'] > 1): ?>
                                    <li class="page-item"><a class="page-link" href="?<?php echo http_build_query(array_merge($_GET, ['page_'.$ti['table'] => $pagination[$ti['table']]['page']-1])); ?>">Prev</a></li>
                                <?php endif; ?>
                                <?php for ($i=1; $i<=$total_pages[$ti['table']]; $i++): ?>
                                    <li class="page-item <?php echo $pagination[$ti['table']]['page']==$i?'active':''; ?>">
                                        <a class="page-link" href="?<?php echo http_build_query(array_merge($_GET, ['page_'.$ti['table'] => $i])); ?>"><?php echo $i; ?></a>
                                    </li>
                                <?php endfor; ?>
                                <?php if ($pagination[$ti['table']]['page'] < $total_pages[$ti['table']]): ?>
                                    <li class="page-item"><a class="page-link" href="?<?php echo http_build_query(array_merge($_GET, ['page_'.$ti['table'] => $pagination[$ti['table']]['page']+1])); ?>">Next</a></li>
                                <?php endif; ?>
                                <li class="page-item">
                                    <select class="form-select d-inline w-auto ms-2" onchange="updatePerPage('<?php echo $ti['table']; ?>',this.value)">
                                        <?php foreach ([5,10,25,50,100] as $pp): ?>
                                            <option value="<?php echo $pp; ?>" <?php echo $pagination[$ti['table']]['per_page']==$pp?'selected':''; ?>><?php echo $pp; ?> per page</option>
                                        <?php endforeach; ?>
                                    </select>
                                </li>
                            </ul>
                        </nav>

                        <a href="?export=<?php echo $ti['table']; ?>&<?php echo http_build_query($_GET); ?>" class="btn btn-outline-secondary mt-2">Export CSV</a>
                    </div>
                <?php endforeach; ?>
        </main>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
<script>
function toggleDatePicker(){
    document.getElementById('datePickerContainer').style.display =
        document.querySelector('[name="time_period"]').value==='range' ? 'block':'none';
}
function resetFilters(){
    const f = document.getElementById('filterForm');
    f.reset();
    f.querySelector('[name="record_type"]').value='all';
    f.querySelector('[name="time_period"]').value='all';
    f.querySelectorAll('select[name^="type_filter"]').forEach(s=>s.value='');
    f.querySelector('[name="member_id"]').value='0';
    f.querySelector('[name="date_field"]').value='created_at';
    f.querySelector('[name="search"]').value='';
    f.querySelector('[name="start_date"]').value='<?php echo date('Y-m-01'); ?>';
    f.querySelector('[name="end_date"]').value='<?php echo date('Y-m-d'); ?>';
    <?php foreach ($tables as $t): ?>
        f.querySelector('[name="page_<?php echo $t; ?>"]').value='1';
        f.querySelector('[name="per_page_<?php echo $t; ?>"]').value='10';
    <?php endforeach; ?>
    f.submit();
}
function updatePerPage(table,val){
    const u=new URL(location);
    u.searchParams.set('per_page_'+table,val);
    u.searchParams.set('page_'+table,'1');
    location=u;
}
function printDashboard(){window.print();}
</script>

<?php
/* ==================== CHARTS JS (only if any permission) ==================== */
if (user_has_permission($link, 'view_payments') || user_has_permission($link, 'view_expenses')
    || user_has_permission($link, 'view_benefits') || user_has_permission($link, 'view_debts')): ?>
<script>
/* Bar */
new Chart(document.getElementById('financialBarChart'),{
    type:'bar',
    data:{labels:['Payments','Expenses','Benefits','Debts'],
          datasets:[{label:'Amount (<?php echo $currency_symbol; ?>)',
                     data:[<?php echo $total_payments; ?>,<?php echo $total_expenses; ?>,
                           <?php echo $total_benefits; ?>,<?php echo $total_debts; ?>],
                     backgroundColor:['#28a745','#dc3545','#007bff','#ffc107']}]},
    options:{responsive:true,scales:{y:{beginAtZero:true}}}}
);

/* Pie */
new Chart(document.getElementById('financialPieChart'),{
    type:'pie',
    data:{labels:['Payments','Expenses','Benefits','Debts'],
          datasets:[{data:[<?php echo $total_payments; ?>,<?php echo $total_expenses; ?>,
                           <?php echo $total_benefits; ?>,<?php echo $total_debts; ?>],
                     backgroundColor:['#28a745','#dc3545','#007bff','#ffc107']}]},
    options:{responsive:true}}
);

/* Histogram – uses PHP-built safe arrays */
new Chart(document.getElementById('financialHistogram'),{
    type:'bar',
    data:{labels:[<?php echo implode(',', $histogram_labels); ?>],
          datasets:[
            {label:'Amount', data:[<?php echo implode(',', $histogram_paid); ?>], backgroundColor:'#28a745'},
            {label:'Excess', data:[<?php echo implode(',', $histogram_excess); ?>], backgroundColor:'#17a2b8'}
          ]},
    options:{responsive:true,scales:{y:{beginAtZero:true}}}}
);

/* Line */
new Chart(document.getElementById('financialLineChart'),{
    type:'line',
    data:{labels:[<?php echo "'" . implode("','", $line_chart_data['labels']) . "'"; ?>],
          datasets:[
            {label:'Payments',data:[<?php echo implode(',', $line_chart_data['payments']); ?>],borderColor:'#28a745',fill:false},
            {label:'Expenses',data:[<?php echo implode(',', $line_chart_data['expenses']); ?>],borderColor:'#dc3545',fill:false},
            {label:'Benefits',data:[<?php echo implode(',', $line_chart_data['benefits']); ?>],borderColor:'#007bff',fill:false},
            {label:'Debts',   data:[<?php echo implode(',', $line_chart_data['debts']); ?>],   borderColor:'#ffc107',fill:false}
          ]},
    options:{responsive:true,scales:{y:{beginAtZero:true}}}}
);
</script>
<?php endif; ?>

<?php require_once 'includes/footer.php'; ?>