<?php
session_start();

require_once 'includes/functions.php';
require_once 'includes/db_config.php';

// Include PHPMailer classes
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'vendor/PHPMailer/src/Exception.php';
require 'vendor/PHPMailer/src/PHPMailer.php';
require 'vendor/PHPMailer/src/SMTP.php';

// Check if user is logged in and is an admin
if (!is_logged_in() || !is_admin()) {
    redirect("login.php");
}

$message = '';
$settings = [];

// Load existing settings
$sql = "SELECT * FROM smtp_settings LIMIT 1";
$result = mysqli_query($link, $sql);
if ($result && mysqli_num_rows($result) > 0) {
    $settings = mysqli_fetch_assoc($result);
}

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Sanitize and get all form data
    $host = sanitize_input($_POST['host']);
    $port = sanitize_input($_POST['port']);
    $username = sanitize_input($_POST['username']);
    $password = $_POST['password']; 
    $from_email = sanitize_input($_POST['from_email']);
    $encryption = sanitize_input($_POST['encryption']);
    $test_email_recipient = sanitize_input($_POST['test_email_recipient']);

    // Check if the input is a save or save-and-test request
    if (isset($_POST['save_settings'])) {
        if (empty($settings)) {
            // Insert new settings
            $sql = "INSERT INTO smtp_settings (host, port, username, password, from_email, encryption) VALUES (?, ?, ?, ?, ?, ?)";
            $stmt = mysqli_prepare($link, $sql);
            mysqli_stmt_bind_param($stmt, "sissss", $host, $port, $username, $password, $from_email, $encryption);
        } else {
            // Update existing settings
            $sql = "UPDATE smtp_settings SET host = ?, port = ?, username = ?, password = ?, from_email = ?, encryption = ? WHERE id = ?";
            $stmt = mysqli_prepare($link, $sql);
            mysqli_stmt_bind_param($stmt, "sissssi", $host, $port, $username, $password, $from_email, $encryption, $settings['id']);
        }
    
        if (mysqli_stmt_execute($stmt)) {
            $message = "SMTP settings saved successfully!";
        } else {
            $message = "Error saving settings: " . mysqli_error($link);
        }
        mysqli_stmt_close($stmt);

        // Update settings array for displaying new values
        $settings = [
            'host' => $host,
            'port' => $port,
            'username' => $username,
            'password' => $password,
            'from_email' => $from_email,
            'encryption' => $encryption
        ];
    }
    
    // Test email functionality
    if (isset($_POST['send_test_email']) && !empty($test_email_recipient)) {
        $mail = new PHPMailer(true);
        try {
            // Server settings
            $mail->isSMTP();
            $mail->Host = $host;
            $mail->SMTPAuth = true;
            $mail->Username = $username;
            $mail->Password = $password;
            $mail->SMTPSecure = $encryption;
            $mail->Port = $port;

            // Recipients
            $mail->setFrom($from_email, 'Club Portal');
            $mail->addAddress($test_email_recipient);
            
            // Content
            $mail->isHTML(true);
            $mail->Subject = 'SMTP Test Email from Club Portal';
            $mail->Body    = 'This is a test email sent from the Club Membership Portal\'s SMTP configuration.';
            
            $mail->send();
            $message .= "<br>Test email sent successfully to " . htmlspecialchars($test_email_recipient) . "!";
        } catch (Exception $e) {
            $message .= "<br>Test email failed. Mailer Error: " . $mail->ErrorInfo;
        }
    }
}
?>

<?php require_once 'includes/header.php'; ?>
<div class="container-fluid">
    <div class="row">
        <?php require_once 'includes/sidebar.php'; ?>
        <main class="col-md-9 col-lg-10 main-content">
            <h2>SMTP Setup</h2>
            
            <?php if ($message): ?>
                <div class="alert alert-<?php echo strpos($message, 'Error') !== false ? 'danger' : 'success'; ?>">
                    <?php echo $message; ?>
                </div>
            <?php endif; ?>

            <div class="card">
                <div class="card-header">SMTP Configuration</div>
                <div class="card-body">
                    <form action="smtp_setup.php" method="post">
                        <div class="form-group">
                            <label for="host">SMTP Host</label>
                            <input type="text" name="host" id="host" class="form-control" value="<?php echo htmlspecialchars($settings['host'] ?? ''); ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="port">SMTP Port</label>
                            <input type="number" name="port" id="port" class="form-control" value="<?php echo htmlspecialchars($settings['port'] ?? ''); ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="username">Username</label>
                            <input type="text" name="username" id="username" class="form-control" value="<?php echo htmlspecialchars($settings['username'] ?? ''); ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="password">Password</label>
                            <input type="password" name="password" id="password" class="form-control" value="<?php echo htmlspecialchars($settings['password'] ?? ''); ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="from_email">"From" Email Address</label>
                            <input type="email" name="from_email" id="from_email" class="form-control" value="<?php echo htmlspecialchars($settings['from_email'] ?? ''); ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="encryption">Encryption</label>
                            <select name="encryption" id="encryption" class="form-control">
                                <option value="tls" <?php echo (isset($settings['encryption']) && $settings['encryption'] == 'tls') ? 'selected' : ''; ?>>TLS</option>
                                <option value="ssl" <?php echo (isset($settings['encryption']) && $settings['encryption'] == 'ssl') ? 'selected' : ''; ?>>SSL</option>
                                <option value="" <?php echo (isset($settings['encryption']) && $settings['encryption'] == '') ? 'selected' : ''; ?>>None</option>
                            </select>
                        </div>
                        
                        <hr>
                        
                        <h3>Test Email</h3>
                        <p>Enter an email address to send a test message using the saved settings.</p>
                        <div class="form-group">
                            <label for="test_email_recipient">Recipient Email</label>
                            <input type="email" name="test_email_recipient" id="test_email_recipient" class="form-control" placeholder="e.g., test@example.com" value="<?php echo htmlspecialchars($_POST['test_email_recipient'] ?? ''); ?>" required>
                        </div>
                        <button type="submit" name="save_settings" class="btn btn-primary">Save Settings</button>
                        <button type="submit" name="send_test_email" class="btn btn-primary">Send Test Email</button>
                    </form>
                </div>
            </div>
        </main>
    </div>
</div>
<?php require_once 'includes/footer.php'; ?>