<?php
// members/list.php
require_once '../includes/functions.php';
require_once '../includes/db_config.php';
if (!is_logged_in() || !is_admin()) redirect("login.php");

$search = $_GET['search'] ?? '';
$page = max(1, (int)($_GET['page'] ?? 1));
$per_page = 20;
$offset = ($page - 1) * $per_page;

$where = "WHERE (u.role IN ('member','pending')) AND (u.deleted_at IS NULL OR u.deleted_at > NOW())";
$params = [];
$types = '';

if ($search) {
    $where .= " AND (u.member_id LIKE ? OR u.full_name LIKE ? OR u.email LIKE ?)";
    $like = "%$search%";
    $params[] = $like; $params[] = $like; $params[] = $like;
    $types .= 'sss';
}

$count_sql = "SELECT COUNT(*) FROM users u $where";
$total = $link->query($count_sql)->fetch_row()[0] ?? 0;
$total_pages = ceil($total / $per_page);

$sql = "SELECT 
            u.id, u.member_id, u.full_name, u.email, u.sex, u.address, u.phone,
            u.membership_status, u.membership_expiry, u.profile_image, u.position
        FROM users u $where 
        ORDER BY u.member_id DESC 
        LIMIT $offset, $per_page";

$stmt = $link->prepare($sql);
if ($types) $stmt->bind_param($types, ...$params);
$stmt->execute();
$result = $stmt->get_result();
$members = $result->fetch_all(MYSQLI_ASSOC);
?>

<?php include '../includes/header.php'; ?>
<div class="container-fluid">
    <div class="row">
        <?php include '../includes/sidebar.php'; ?>
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Members</h1>
                <div>
                    <a href="executives.php" class="btn btn-info">Executives</a>
                    <a href="?export=pdf" class="btn btn-danger">PDF</a>
                    <a href="?export=csv" class="btn btn-success">CSV</a>
                </div>
            </div>

            <form method="GET" class="mb-3">
                <div class="input-group">
                    <input type="text" name="search" class="form-control" placeholder="Search by ID, Name, Email..." value="<?=htmlspecialchars($search)?>">
                    <button class="btn btn-primary">Search</button>
                </div>
            </form>

            <div class="table-responsive">
                <table class="table table-striped table-sm">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Photo</th>
                            <th>Name</th>
                            <th>Sex</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Status</th>
                            <th>Expiry</th>
                            <th>Position</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($members as $m): ?>
                        <tr>
                            <td><?=htmlspecialchars($m['member_id'])?></td>
                            <td>
                                <?php if ($m['profile_image']): ?>
                                    <img src="../uploads/profiles/<?=htmlspecialchars($m['profile_image'])?>" width="40" class="rounded-circle">
                                <?php else: ?>
                                    <div class="bg-secondary rounded-circle" style="width:40px;height:40px;"></div>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="view.php?id=<?=$m['id']?>">
                                    <?=htmlspecialchars($m['full_name'])?>
                                </a>
                            </td>
                            <td><?=ucfirst($m['sex'] ?? '-')?></td>
                            <td><?=htmlspecialchars($m['email'])?></td>
                            <td><?=htmlspecialchars($m['phone'] ?? '-')?></td>
                            <td><span class="badge bg-<?=status_color($m['membership_status'])?>"><?=htmlspecialchars($m['membership_status'])?></span></td>
                            <td><?=format_date($m['membership_expiry'])?></td>
                            <td><?=htmlspecialchars($m['position'] ?? '-')?></td>
                            <td>
                                <a href="edit.php?id=<?=$m['id']?>" class="btn btn-sm btn-warning">Edit</a>
                                <a href="id-card.php?id=<?=$m['id']?>" target="_blank" class="btn btn-sm btn-info">ID Card</a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <nav>
                <ul class="pagination">
                    <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                        <li class="page-item <?= $i == $page ? 'active' : '' ?>">
                            <a class="page-link" href="?page=<?=$i?>&search=<?=urlencode($search)?>"><?=$i?></a>
                        </li>
                    <?php endfor; ?>
                </ul>
            </nav>
        </main>
    </div>
</div>

<?php 
// Export handlers
if (isset($_GET['export'])) {
    require_once 'export.php';
    exit;
}
?>
<?php include '../includes/footer.php'; ?>