<?php
// members/executives.php
require_once '../includes/functions.php';
require_once '../includes/db_config.php';
if (!is_logged_in() || !is_admin()) redirect("login.php");

$positions = ['President', 'Vice President', 'Secretary', 'Treasurer', 'PRO', 'Member'];

if ($_POST['assign']) {
    $user_id = (int)$_POST['user_id'];
    $position = sanitize_input($_POST['position']);
    $start = $_POST['tenure_start'];
    $end = $_POST['tenure_end'] ?: null;

    $link->query("UPDATE users SET position='$position', tenure_start='$start', tenure_end='$end' WHERE id=$user_id");
    $link->query("INSERT INTO executives (user_id, position, tenure_start, tenure_end, created_by) VALUES ($user_id, '$position', '$start', ".($end?"'$end'":'NULL').", {$_SESSION['user_id']})");
}

$execs = $link->query("SELECT u.*, e.tenure_start, e.tenure_end FROM users u LEFT JOIN executives e ON u.id=e.user_id WHERE u.position IS NOT NULL ORDER BY e.tenure_start DESC")->fetch_all(MYSQLI_ASSOC);
?>

<?php include '../includes/header.php'; ?>
<div class="container-fluid">
    <div class="row">
        <?php include '../includes/sidebar.php'; ?>
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <h2>Executive Board</h2>
            <table class="table">
                <thead><tr><th>Photo</th><th>Name</th><th>Position</th><th>Tenure</th><th>Actions</th></tr></thead>
                <tbody>
                    <?php foreach ($execs as $e): ?>
                    <tr>
                        <td><img src="../uploads/profiles/<?=htmlspecialchars($e['profile_image']??'default.png')?>" width="40" class="rounded-circle"></td>
                        <td><?=htmlspecialchars($e['full_name'])?></td>
                        <td><strong><?=htmlspecialchars($e['position'])?></strong></td>
                        <td><?=format_date($e['tenure_start'])?> → <?=format_date($e['tenure_end'])?></td>
                        <td>
                            <button class="btn btn-sm btn-danger" onclick="removeExec(<?=$e['id']?>)">Remove</button>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

            <h4>Assign New</h4>
            <form method="POST">
                <select name="user_id" required class="form-control d-inline w-auto">
                    <?php
                    $members = $link->query("SELECT id, full_name FROM users WHERE role='member' AND position IS NULL");
                    while ($m = $members->fetch_assoc()) {
                        echo "<option value='{$m['id']}'>{$m['full_name']}</option>";
                    }
                    ?>
                </select>
                <select name="position" class="form-control d-inline w-auto">
                    <?php foreach ($positions as $p) echo "<option>$p</option>"; ?>
                </select>
                <input type="date" name="tenure_start" required class="form-control d-inline w-auto">
                <input type="date" name="tenure_end" class="form-control d-inline w-auto">
                <button name="assign" class="btn btn-primary">Assign</button>
            </form>
        </main>
    </div>
</div>
<?php include '../includes/footer.php'; ?>