<?php
// accountant_dashboard.php
ob_start();
session_start();

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Clear OPCache
if (function_exists('opcache_reset')) {
    opcache_reset();
}

require_once 'includes/functions.php';
require_once 'includes/db_config.php';

// Session timeout
$timeout = 1800; // 30 minutes
if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity']) > $timeout) {
    session_unset();
    session_destroy();
    redirect("login.php?timeout=1");
}
$_SESSION['last_activity'] = time();

// Restrict to accountants
if (!is_logged_in() || $_SESSION['user_role'] !== 'accountant') {
    redirect("login.php");
}

$system_name = get_setting('system_name', $link) ?? 'Club Portal';
$currency_symbol = get_setting('currency_symbol', $link) ?? '₦';

// Fetch accountant's token balance
$token_balance = get_token_balance($link, $_SESSION['user_id']);

// Fetch total members
$total_members = 0;
$sql_members = "SELECT COUNT(*) AS total FROM users WHERE role = 'member' AND (deleted_at IS NULL OR deleted_at > NOW())";
$result_members = mysqli_query($link, $sql_members);
if ($result_members) {
    $total_members = mysqli_fetch_assoc($result_members)['total'] ?? 0;
    mysqli_free_result($result_members);
}

// Fetch total payments
$total_payments = 0;
$sql_payments = "SELECT COALESCE(SUM(amount), 0) AS total FROM payments WHERE payment_status = 'Paid' AND deleted_at IS NULL";
$result_payments = mysqli_query($link, $sql_payments);
if ($result_payments) {
    $total_payments = mysqli_fetch_assoc($result_payments)['total'] ?? 0;
    mysqli_free_result($result_payments);
}

// Fetch total expenses
$total_expenses = 0;
$sql_expenses = "SELECT COALESCE(SUM(amount), 0) AS total FROM expenses WHERE deleted_at IS NULL";
$result_expenses = mysqli_query($link, $sql_expenses);
if ($result_expenses) {
    $total_expenses = mysqli_fetch_assoc($result_expenses)['total'] ?? 0;
    mysqli_free_result($result_expenses);
}

// Fetch total benefits
$total_benefits = 0;
$sql_benefits = "SELECT COALESCE(SUM(amount), 0) AS total FROM member_benefits WHERE deleted_at IS NULL";
$result_benefits = mysqli_query($link, $sql_benefits);
if ($result_benefits) {
    $total_benefits = mysqli_fetch_assoc($result_benefits)['total'] ?? 0;
    mysqli_free_result($result_benefits);
}

ob_end_clean();
?>

<?php require_once 'includes/header.php'; ?>

<script>
document.title = 'Accountant Dashboard - <?php echo htmlspecialchars($system_name); ?>';
</script>

<style>
.main-content {
    padding: 20px;
}
.card-stats {
    margin-bottom: 20px;
}
.welcome-message {
    margin-bottom: 20px;
}
</style>

<div class="container-fluid">
    <div class="row">
        <?php require_once 'includes/sidebar.php'; ?>
        <main class="col-md-9 col-lg-10 main-content">
            <div class="welcome-message">
                <h2>Welcome, <?php echo htmlspecialchars($_SESSION['username'] ?? 'Accountant'); ?>!</h2>
                <p>Today's Date: <?php echo date('F j, Y'); ?></p>
            </div>

            <div class="row">
                <div class="col-md-3">
                    <div class="card card-stats">
                        <div class="card-body">
                            <h5 class="card-title">Total Members</h5>
                            <p class="card-text"><?php echo htmlspecialchars($total_members); ?></p>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card card-stats">
                        <div class="card-body">
                            <h5 class="card-title">Available Tokens</h5>
                            <p class="card-text"><?php echo htmlspecialchars($token_balance); ?></p>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card card-stats">
                        <div class="card-body">
                            <h5 class="card-title">Total Payments</h5>
                            <p class="card-text"><?php echo htmlspecialchars($currency_symbol . number_format($total_payments, 2)); ?></p>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card card-stats">
                        <div class="card-body">
                            <h5 class="card-title">Total Expenses</h5>
                            <p class="card-text"><?php echo htmlspecialchars($currency_symbol . number_format($total_expenses, 2)); ?></p>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card card-stats">
                        <div class="card-body">
                            <h5 class="card-title">Total Benefits</h5>
                            <p class="card-text"><?php echo htmlspecialchars($currency_symbol . number_format($total_benefits, 2)); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">Quick Actions</div>
                <div class="card-body">
                    <?php if (user_has_permission($link, 'view_payments')): ?>
                        <a href="record_payments.php" class="btn btn-primary mb-2">Record Payments</a>
                    <?php endif; ?>
                    <?php if (user_has_permission($link, 'view_expenses')): ?>
                        <a href="record_expenses.php" class="btn btn-primary mb-2">Record Expenses</a>
                    <?php endif; ?>
                    <?php if (user_has_permission($link, 'view_benefits')): ?>
                        <a href="record_benefits.php" class="btn btn-primary mb-2">Record Benefits</a>
                    <?php endif; ?>
                    <a href="profile.php" class="btn btn-secondary mb-2">My Profile</a>
                </div>
            </div>
        </main>
    </div>
</div>

<?php require_once 'includes/footer.php'; ?>