<?php
$tables = ['payments', 'expenses', 'debts', 'benefits'];
require_once 'includes/header.php';
?>

<script>
// Set dynamic page title
document.title = 'Financial Summary - <?php echo htmlspecialchars($system_name); ?>';
</script>

<style>
    .main-content { padding: 20px; }
    .card { transition: transform 0.2s, box-shadow 0.2s; border: none; border-radius: 10px; }
    .card:hover { transform: translateY(-5px); box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1); }
    .card-header { font-weight: bold; border-bottom: none; }
    .card-body h5 { font-size: 1.5rem; margin: 0; }
    .table-responsive { max-height: 500px; overflow-y: auto; }
    .filter-section { background: #f8f9fa; padding: 15px; border-radius: 10px; }
    .filter-section .btn-reset { margin-top: 30px; }
    @media print {
        body * { visibility: hidden; }
        .print-card, .print-card *, #dashboardCards, #dashboardCards * { visibility: visible; }
        .print-card, #dashboardCards { position: static; width: 100%; page-break-inside: avoid; }
        .no-print { display: none !important; }
        table { border-collapse: collapse; width: 100%; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; font-weight: bold; }
        .card { border: none; box-shadow: none; }
        .card-header { border-bottom: 1px solid #ddd; background: none; }
    }
</style>

<div class="container-fluid">
    <div class="row">
        <?php require_once 'includes/sidebar.php'; ?>
        <main class="col-md-9 col-lg-10 main-content">
            <h2>Financial Summary</h2>
            <hr>

            <!-- Cards Section -->
            <div class="row mb-4" id="dashboardCards">
                <?php if (user_has_permission($link, 'view_payments')): ?>
                    <div class="col-md-3 mb-3">
                        <div class="card text-white bg-success">
                            <div class="card-header"><i class="fas fa-money-check-alt me-2"></i>Total Payments</div>
                            <div class="card-body">
                                <h5 class="card-title"><?php echo format_currency($total_payments, $currency_symbol); ?></h5>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if (user_has_permission($link, 'view_member_directory')): ?>
                    <div class="col-md-3 mb-3">
                        <div class="card text-white bg-info">
                            <div class="card-header"><i class="fas fa-users me-2"></i>Total Members</div>
                            <div class="card-body">
                                <h5 class="card-title"><?php echo htmlspecialchars($total_members); ?></h5>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if (user_has_permission($link, 'view_benefits')): ?>
                    <div class="col-md-3 mb-3">
                        <div class="card text-white bg-primary">
                            <div class="card-header"><i class="fas fa-gift me-2"></i>Total Benefits</div>
                            <div class="card-body">
                                <h5 class="card-title"><?php echo format_currency($total_benefits, $currency_symbol); ?></h5>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if (user_has_permission($link, 'view_debts')): ?>
                    <div class="col-md-3 mb-3">
                        <div class="card text-white bg-warning">
                            <div class="card-header"><i class="fas fa-exclamation-triangle me-2"></i>Total Debts</div>
                            <div class="card-body">
                                <h5 class="card-title"><?php echo format_currency($total_debts, $currency_symbol); ?></h5>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="col-md-3 mb-3">
                    <div class="card text-white bg-dark">
                        <div class="card-header"><i class="fas fa-wallet me-2"></i>Current Balance</div>
                        <div class="card-body">
                            <h5 class="card-title"><?php echo format_currency($current_balance, $currency_symbol); ?></h5>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 mb-3">
                    <div class="card text-white bg-secondary">
                        <div class="card-header"><i class="fas fa-list me-2"></i>Total Payment Types</div>
                        <div class="card-body">
                            <h5 class="card-title"><?php echo htmlspecialchars($total_payment_types); ?></h5>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 mb-3">
                    <div class="card text-white bg-info">
                        <div class="card-header"><i class="fas fa-calendar-alt me-2"></i>Previous Month Balance</div>
                        <div class="card-body">
                            <h5 class="card-title"><?php echo format_currency($prev_balances['month'], $currency_symbol); ?></h5>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 mb-3">
                    <div class="card text-white bg-primary">
                        <div class="card-header"><i class="fas fa-calendar-check me-2"></i>Previous Year Balance</div>
                        <div class="card-body">
                            <h5 class="card-title"><?php echo format_currency($prev_balances['year'], $currency_symbol); ?></h5>
                        </div>
                    </div>
                </div>
                <?php if (!user_has_permission($link, 'view_payments') && !user_has_permission($link, 'view_member_directory') && !user_has_permission($link, 'view_debts') && !user_has_permission($link, 'view_benefits')): ?>
                    <div class="col-12">
                        <div class="alert alert-warning">
                            No features are currently assigned to your role. Contact the administrator to update your permissions.
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            <!-- Print Dashboard Button -->
            <?php if ($is_admin): ?>
                <div class="mb-4">
                    <button class="btn btn-outline-secondary" onclick="printDashboard()"><i class="fas fa-print me-2"></i>Print Dashboard</button>
                </div>
            <?php endif; ?>

            <!-- Filters Section -->
            <div class="mb-4 filter-section">
                <form id="filterForm" method="GET" action="">
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <label for="recordTypeFilter" class="form-label">Record Type:</label>
                            <select id="recordTypeFilter" name="record_type" class="form-select">
                                <option value="all" <?php echo $record_type === 'all' ? 'selected' : ''; ?>>All</option>
                                <option value="payments" <?php echo $record_type === 'payments' ? 'selected' : ''; ?>>Payments</option>
                                <option value="expenses" <?php echo $record_type === 'expenses' ? 'selected' : ''; ?>>Expenses</option>
                                <option value="benefits" <?php echo $record_type === 'benefits' ? 'selected' : ''; ?>>Benefits</option>
                                <option value="debts" <?php echo $record_type === 'debts' ? 'selected' : ''; ?>>Debts</option>
                            </select>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label for="timePeriodFilter" class="form-label">Time Period:</label>
                            <select id="timePeriodFilter" name="time_period" class="form-select" onchange="toggleDatePicker()">
                                <option value="all" <?php echo $time_period === 'all' ? 'selected' : ''; ?>>All Time</option>
                                <option value="date" <?php echo $time_period === 'date' ? 'selected' : ''; ?>>Specific Date</option>
                                <option value="week" <?php echo $time_period === 'week' ? 'selected' : ''; ?>>Last Week</option>
                                <option value="month" <?php echo $time_period === 'month' ? 'selected' : ''; ?>>Last Month</option>
                                <option value="year" <?php echo $time_period === 'year' ? 'selected' : ''; ?>>Last Year</option>
                            </select>
                        </div>
                        <div class="col-md-3 mb-3" id="datePickerContainer" style="display: <?php echo $time_period === 'date' ? 'block' : 'none'; ?>;">
                            <label for="filterDate" class="form-label">Select Date:</label>
                            <input type="date" id="filterDate" name="filter_date" class="form-control" value="<?php echo htmlspecialchars($filter_date); ?>">
                        </div>
                        <div class="col-md-3 mb-3">
                            <label for="typeFilter" class="form-label">Type Filter:</label>
                            <select id="typeFilter" name="type_filter" class="form-select">
                                <option value="">All Types</option>
                                <?php foreach ($type_options as $category => $types): ?>
                                    <?php if (!empty($types) && in_array($record_type, ['all', str_replace('payment', 'payments', $category)])): ?>
                                        <optgroup label="<?php echo ucfirst($category); ?> Types">
                                            <?php foreach ($types as $type): ?>
                                                <option value="<?php echo htmlspecialchars($category . '_' . $type); ?>" <?php echo $type_filter === $category . '_' . $type ? 'selected' : ''; ?>><?php echo htmlspecialchars($type); ?></option>
                                            <?php endforeach; ?>
                                        </optgroup>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label for="dateField" class="form-label">Date Field (Debts):</label>
                            <select id="dateField" name="date_field" class="form-select">
                                <option value="created_at" <?php echo $date_field === 'created_at' ? 'selected' : ''; ?>>Created At</option>
                                <option value="due_date" <?php echo $date_field === 'due_date' ? 'selected' : ''; ?>>Due Date</option>
                            </select>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label for="search" class="form-label">Search:</label>
                            <input type="text" id="search" name="search" class="form-control" value="<?php echo htmlspecialchars($search); ?>" placeholder="Search by name, type, or ID">
                        </div>
                        <div class="col-md-3 mb-3">
                            <button type="submit" class="btn btn-primary mt-4">Apply Filters</button>
                            <button type="button" class="btn btn-secondary btn-reset mt-4 ms-2" onclick="resetFilters()">Reset Filters</button>
                        </div>
                        <?php foreach ($tables as $table): ?>
                            <input type="hidden" name="page_<?php echo $table; ?>" value="<?php echo $pagination[$table]['page']; ?>">
                            <input type="hidden" name="per_page_<?php echo $table; ?>" value="<?php echo $pagination[$table]['per_page']; ?>">
                        <?php endforeach; ?>
                    </div>
                </form>
            </div>

            <!-- Charts Section -->
            <?php if (user_has_permission($link, 'view_payments') || user_has_permission($link, 'view_debts') || user_has_permission($link, 'view_benefits')): ?>
                <div class="card mb-4">
                    <div class="card-header">Financial Breakdown (Bar Chart)</div>
                    <div class="card-body">
                        <canvas id="financialBarChart" height="100"></canvas>
                        <?php if ($total_payments == 0 && $total_expenses == 0 && $total_benefits == 0 && $total_debts == 0): ?>
                            <p class="text-muted text-center mt-3">No financial data available.</p>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="row mb-4">
                    <div class="col-md-4 mb-3">
                        <div class="card">
                            <div class="card-header">Financial Overview (Pie Chart)</div>
                            <div class="card-body">
                                <canvas id="financialPieChart" height="200"></canvas>
                                <?php if ($total_payments == 0 && $total_expenses == 0 && $total_benefits == 0 && $total_debts == 0): ?>
                                    <p class="text-muted text-center mt-3">No financial data available.</p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 mb-3">
                        <div class="card">
                            <div class="card-header">Financial Breakdown by Type (Histogram)</div>
                            <div class="card-body">
                                <canvas id="financialHistogram" height="200"></canvas>
                                <?php if (empty($payment_types_summary) && empty($expense_types_summary) && empty($benefit_types_summary)): ?>
                                    <p class="text-muted text-center mt-3">No financial data available.</p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 mb-3">
                        <div class="card">
                            <div class="card-header">Financial Trend (Line Chart)</div>
                            <div class="card-body">
                                <canvas id="financialLineChart" height="200"></canvas>
                                <?php if (empty($line_chart_data['payments']) && empty($line_chart_data['expenses']) && empty($line_chart_data['benefits']) && empty($line_chart_data['debts'])): ?>
                                    <p class="text-muted text-center mt-3">No financial data available.</p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Type Summaries -->
            <div class="card mb-4">
                <div class="card-header">Type Summaries</div>
                <div class="card-body">
                    <div class="row">
                        <?php foreach ([
                            'Payments' => ['data' => $payment_types_summary, 'columns' => ['Type', 'Required Amount', 'Total Paid', 'Total Debt']],
                            'Expenses' => ['data' => $expense_types_summary, 'columns' => ['Type', 'Total']],
                            'Benefits' => ['data' => $benefit_types_summary, 'columns' => ['Type', 'Total']]
                        ] as $title => $info): ?>
                            <?php if (!empty($info['data']) && ($record_type === 'all' || $record_type === strtolower($title))): ?>
                                <div class="col-md-4 mb-3">
                                    <h5><?php echo htmlspecialchars($title); ?> Summary</h5>
                                    <div class="table-responsive print-card">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <?php foreach ($info['columns'] as $column): ?>
                                                        <th><?php echo htmlspecialchars($column); ?></th>
                                                    <?php endforeach; ?>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($info['data'] as $row): ?>
                                                    <tr>
                                                        <td><?php echo htmlspecialchars($row['type_name']); ?></td>
                                                        <?php if ($title === 'Payments'): ?>
                                                            <td><?php echo format_currency($row['required_amount'], $currency_symbol); ?></td>
                                                            <td><?php echo format_currency($row['total_paid'], $currency_symbol); ?></td>
                                                            <td><?php echo format_currency($row['total_debt'], $currency_symbol); ?></td>
                                                        <?php else: ?>
                                                            <td><?php echo format_currency($row['total'], $currency_symbol); ?></td>
                                                        <?php endif; ?>
                                                    </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>

            <!-- Data Tables -->
            <?php foreach ([
                'Payments' => ['data' => $payments, 'columns' => ['ID', 'Member ID', 'Name', 'Type', 'Amount', 'Status', 'Date', 'Cycle/Event'], 'permission' => 'view_payments', 'table' => 'payments'],
                'Expenses' => ['data' => $expenses, 'columns' => ['ID', 'Type', 'Amount', 'Description', 'Date'], 'permission' => 'view_expenses', 'table' => 'expenses'],
                'Benefits' => ['data' => $benefits, 'columns' => ['ID', 'Member ID', 'Name', 'Type', 'Amount', 'Date'], 'permission' => 'view_benefits', 'table' => 'benefits'],
                'Debts' => ['data' => $debts, 'columns' => ['Member ID', 'Name', 'Type', 'Required', 'Paid', 'Debt', 'Cycle', 'Due Date'], 'permission' => 'view_debts', 'table' => 'debts']
            ] as $title => $info): ?>
                <?php if (!empty($info['data']) && user_has_permission($link, $info['permission']) && ($record_type === 'all' || $record_type === $info['table'])): ?>
                    <div class="card mb-4 print-card">
                        <div class="card-header"><?php echo htmlspecialchars($title); ?></div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <?php foreach ($info['columns'] as $column): ?>
                                                <th><?php echo htmlspecialchars($column); ?></th>
                                            <?php endforeach; ?>
                                            <?php if ($is_admin && $title !== 'Expenses'): ?>
                                                <th class="no-print">Actions</th>
                                            <?php endif; ?>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($info['data'] as $row): ?>
                                            <tr>
                                                <?php if ($title === 'Payments'): ?>
                                                    <td><?php echo htmlspecialchars($row['id']); ?></td>
                                                    <td><?php echo htmlspecialchars($row['member_id']); ?></td>
                                                    <td><?php echo htmlspecialchars($row['full_name']); ?></td>
                                                    <td><?php echo htmlspecialchars($row['payment_type']); ?></td>
                                                    <td><?php echo format_currency($row['amount'], $currency_symbol); ?></td>
                                                    <td><?php echo htmlspecialchars($row['payment_status']); ?></td>
                                                    <td><?php echo htmlspecialchars(date('Y-m-d', strtotime($row['created_at']))); ?></td>
                                                    <td><?php echo htmlspecialchars($row['payment_cycle'] ?? $row['event_date'] ?? 'N/A'); ?></td>
                                                    <?php if ($is_admin): ?>
                                                        <td class="no-print">
                                                            <a href="edit_payment.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-outline-primary"><i class="fas fa-edit"></i></a>
                                                            <a href="delete_payment.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Are you sure you want to delete this payment?');"><i class="fas fa-trash"></i></a>
                                                        </td>
                                                    <?php endif; ?>
                                                <?php elseif ($title === 'Expenses'): ?>
                                                    <td><?php echo htmlspecialchars($row['id']); ?></td>
                                                    <td><?php echo htmlspecialchars($row['expense_type'] ?? 'N/A'); ?></td>
                                                    <td><?php echo format_currency($row['amount'], $currency_symbol); ?></td>
                                                    <td><?php echo htmlspecialchars($row['description']); ?></td>
                                                    <td><?php echo htmlspecialchars(date('Y-m-d', strtotime($row['created_at']))); ?></td>
                                                <?php elseif ($title === 'Benefits'): ?>
                                                    <td><?php echo htmlspecialchars($row['id']); ?></td>
                                                    <td><?php echo htmlspecialchars($row['member_id']); ?></td>
                                                    <td><?php echo htmlspecialchars($row['full_name']); ?></td>
                                                    <td><?php echo htmlspecialchars($row['benefit_type']); ?></td>
                                                    <td><?php echo format_currency($row['amount'], $currency_symbol); ?></td>
                                                    <td><?php echo htmlspecialchars(date('Y-m-d', strtotime($row['created_at']))); ?></td>
                                                    <?php if ($is_admin): ?>
                                                        <td class="no-print">
                                                            <a href="edit_benefit.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-outline-primary"><i class="fas fa-edit"></i></a>
                                                            <a href="delete_benefit.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Are you sure you want to delete this benefit?');"><i class="fas fa-trash"></i></a>
                                                        </td>
                                                    <?php endif; ?>
                                                <?php elseif ($title === 'Debts'): ?>
                                                    <td><?php echo htmlspecialchars($row['member_id']); ?></td>
                                                    <td><?php echo htmlspecialchars($row['full_name']); ?></td>
                                                    <td><?php echo htmlspecialchars($row['payment_type']); ?></td>
                                                    <td><?php echo format_currency($row['required_amount'], $currency_symbol); ?></td>
                                                    <td><?php echo format_currency($row['total_paid'], $currency_symbol); ?></td>
                                                    <td><?php echo format_currency($row['debt'], $currency_symbol); ?></td>
                                                    <td><?php echo htmlspecialchars($row['payment_cycle'] ?? 'N/A'); ?></td>
                                                    <td><?php echo htmlspecialchars($row['due_date'] ?? 'N/A'); ?></td>
                                                    <?php if ($is_admin): ?>
                                                        <td class="no-print">
                                                            <a href="edit_member.php?id=<?php echo $row['user_id']; ?>" class="btn btn-sm btn-outline-primary"><i class="fas fa-edit"></i></a>
                                                        </td>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                            <!-- Pagination -->
                            <nav aria-label="Page navigation">
                                <ul class="pagination">
                                    <?php if ($pagination[$info['table']]['page'] > 1): ?>
                                        <li class="page-item">
                                            <a class="page-link" href="?<?php echo http_build_query(array_merge($_GET, ['page_' . $info['table'] => $pagination[$info['table']]['page'] - 1])); ?>">Previous</a>
                                        </li>
                                    <?php endif; ?>
                                    <?php for ($i = 1; $i <= $total_pages[array_search($info['table'], $tables)]; $i++): ?>
                                        <li class="page-item <?php echo $pagination[$info['table']]['page'] == $i ? 'active' : ''; ?>">
                                            <a class="page-link" href="?<?php echo http_build_query(array_merge($_GET, ['page_' . $info['table'] => $i])); ?>"><?php echo $i; ?></a>
                                        </li>
                                    <?php endfor; ?>
                                    <?php if ($pagination[$info['table']]['page'] < $total_pages[array_search($info['table'], $tables)]): ?>
                                        <li class="page-item">
                                            <a class="page-link" href="?<?php echo http_build_query(array_merge($_GET, ['page_' . $info['table'] => $pagination[$info['table']]['page'] + 1])); ?>">Next</a>
                                        </li>
                                    <?php endif; ?>
                                    <li class="page-item">
                                        <select class="form-select d-inline w-auto ms-2" onchange="updatePerPage('<?php echo $info['table']; ?>', this.value)">
                                            <?php foreach ([5, 10, 25, 50, 100] as $per_page): ?>
                                                <option value="<?php echo $per_page; ?>" <?php echo $pagination[$info['table']]['per_page'] == $per_page ? 'selected' : ''; ?>><?php echo $per_page; ?> per page</option>
                                            <?php endforeach; ?>
                                        </select>
                                    </li>
                                </ul>
                            </nav>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endforeach; ?>
        </main>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
<script>
function toggleDatePicker() {
    const timePeriod = document.getElementById('timePeriodFilter').value;
    document.getElementById('datePickerContainer').style.display = timePeriod === 'date' ? 'block' : 'none';
}

function resetFilters() {
    const form = document.getElementById('filterForm');
    form.querySelector('#recordTypeFilter').value = 'all';
    form.querySelector('#timePeriodFilter').value = 'all';
    form.querySelector('#typeFilter').value = '';
    form.querySelector('#dateField').value = 'created_at';
    form.querySelector('#search').value = '';
    form.querySelector('#filterDate').value = '<?php echo date('Y-m-d'); ?>';
    <?php foreach ($tables as $table): ?>
        form.querySelector('input[name="page_<?php echo $table; ?>"]').value = '1';
        form.querySelector('input[name="per_page_<?php echo $table; ?>"]').value = '5';
    <?php endforeach; ?>
    form.submit();
}

function updatePerPage(table, perPage) {
    const url = new URL(window.location);
    url.searchParams.set('per_page_' + table, perPage);
    url.searchParams.set('page_' + table, '1');
    window.location = url;
}

function printDashboard() {
    window.print();
}

<?php if (user_has_permission($link, 'view_payments') || user_has_permission($link, 'view_debts') || user_has_permission($link, 'view_benefits')): ?>
    // Bar Chart
    new Chart(document.getElementById('financialBarChart'), {
        type: 'bar',
        data: {
            labels: ['Payments', 'Expenses', 'Benefits', 'Debts'],
            datasets: [{
                label: 'Amount (<?php echo htmlspecialchars($currency_symbol); ?>)',
                data: [
                    <?php echo $total_payments; ?>,
                    <?php echo $total_expenses; ?>,
                    <?php echo $total_benefits; ?>,
                    <?php echo $total_debts; ?>
                ],
                backgroundColor: ['#28a745', '#dc3545', '#007bff', '#ffc107'],
                borderColor: ['#218838', '#c82333', '#0069d9', '#e0a800'],
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            scales: { y: { beginAtZero: true, title: { display: true, text: 'Amount (<?php echo htmlspecialchars($currency_symbol); ?>)' } } },
            plugins: { legend: { display: false } }
        }
    });

    // Pie Chart
    new Chart(document.getElementById('financialPieChart'), {
        type: 'pie',
        data: {
            labels: ['Payments', 'Expenses', 'Benefits', 'Debts'],
            datasets: [{
                data: [
                    <?php echo $total_payments; ?>,
                    <?php echo $total_expenses; ?>,
                    <?php echo $total_benefits; ?>,
                    <?php echo $total_debts; ?>
                ],
                backgroundColor: ['#28a745', '#dc3545', '#007bff', '#ffc107'],
                borderColor: '#fff',
                borderWidth: 2
            }]
        },
        options: {
            responsive: true,
            plugins: { legend: { position: 'top' } }
        }
    });

    // Histogram
    new Chart(document.getElementById('financialHistogram'), {
        type: 'bar',
        data: {
            labels: [
                <?php
                $all_types = array_merge(
                    array_map(fn($row) => "'Payment: " . addslashes($row['type_name']) . "'", $payment_types_summary),
                    array_map(fn($row) => "'Expense: " . addslashes($row['type_name']) . "'", $expense_types_summary),
                    array_map(fn($row) => "'Benefit: " . addslashes($row['type_name']) . "'", $benefit_types_summary)
                );
                echo implode(',', $all_types);
                ?>
            ],
            datasets: [{
                label: 'Amount (<?php echo htmlspecialchars($currency_symbol); ?>)',
                data: [
                    <?php
                    $values = array_merge(
                        array_map(fn($row) => $row['total_paid'], $payment_types_summary),
                        array_map(fn($row) => $row['total'], $expense_types_summary),
                        array_map(fn($row) => $row['total'], $benefit_types_summary)
                    );
                    echo implode(',', $values);
                    ?>
                ],
                backgroundColor: [
                    <?php
                    $colors = array_merge(
                        array_fill(0, count($payment_types_summary), "'#28a745'"),
                        array_fill(0, count($expense_types_summary), "'#dc3545'"),
                        array_fill(0, count($benefit_types_summary), "'#007bff'")
                    );
                    echo implode(',', $colors);
                    ?>
                ],
                borderColor: [
                    <?php
                    $border_colors = array_merge(
                        array_fill(0, count($payment_types_summary), "'#218838'"),
                        array_fill(0, count($expense_types_summary), "'#c82333'"),
                        array_fill(0, count($benefit_types_summary), "'#0069d9'")
                    );
                    echo implode(',', $border_colors);
                    ?>
                ],
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            scales: { y: { beginAtZero: true, title: { display: true, text: 'Amount (<?php echo htmlspecialchars($currency_symbol); ?>)' } } },
            plugins: { legend: { display: false } }
        }
    });

    // Line Chart
    new Chart(document.getElementById('financialLineChart'), {
        type: 'line',
        data: {
            labels: [<?php echo "'" . implode("','", $line_chart_data['labels']) . "'"; ?>],
            datasets: [
                {
                    label: 'Payments',
                    data: [<?php echo implode(',', $line_chart_data['payments']); ?>],
                    borderColor: '#28a745',
                    fill: false
                },
                {
                    label: 'Expenses',
                    data: [<?php echo implode(',', $line_chart_data['expenses']); ?>],
                    borderColor: '#dc3545',
                    fill: false
                },
                {
                    label: 'Benefits',
                    data: [<?php echo implode(',', $line_chart_data['benefits']); ?>],
                    borderColor: '#007bff',
                    fill: false
                },
                {
                    label: 'Debts',
                    data: [<?php echo implode(',', $line_chart_data['debts']); ?>],
                    borderColor: '#ffc107',
                    fill: false
                }
            ]
        },
        options: {
            responsive: true,
            scales: {
                y: { beginAtZero: true, title: { display: true, text: 'Amount (<?php echo htmlspecialchars($currency_symbol); ?>)' } },
                x: { title: { display: true, text: 'Month' } }
            },
            plugins: { legend: { position: 'top' } }
        }
    });
<?php endif; ?>
</script>

<?php require_once 'includes/footer.php'; ?>