<?php
require_once 'includes/functions.php';
require_once 'includes/db_config.php';

// Check if the user is logged in and has admin privileges
if (!is_logged_in() || !is_admin()) {
    redirect("login.php");
}

$message = '';

// Handle form submission to add a new payment record
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['submit_payment'])) {
    $member_id = intval($_POST['member_id']);
    $amount = floatval($_POST['amount']);
    $payment_date = $_POST['payment_date'];
    $notes = sanitize_input($_POST['notes']);
    
    // Validate required fields
    if (empty($member_id) || empty($amount) || empty($payment_date)) {
        $message = "Please fill in all required fields: Member ID, Amount, and Date.";
    } else {
        // Use a prepared statement to securely insert the data
        $sql = "INSERT INTO payments (member_id, amount, payment_date, notes) VALUES (?, ?, ?, ?)";
        
        if ($stmt = mysqli_prepare($link, $sql)) {
            mysqli_stmt_bind_param($stmt, "idss", $member_id, $amount, $payment_date, $notes);
            
            if (mysqli_stmt_execute($stmt)) {
                $message = "Payment recorded successfully!";
            } else {
                $message = "Error recording payment: " . mysqli_error($link);
            }
            mysqli_stmt_close($stmt);
        } else {
            $message = "Database error: Could not prepare statement.";
        }
    }
}
?>

<?php require_once 'includes/header.php'; ?>
<div class="container-fluid">
    <div class="row">
        <?php require_once 'includes/sidebar.php'; ?>
        <main class="col-md-9 col-lg-10 main-content">
            <h2>Record Payment</h2>
            
            <?php if ($message): ?>
                <div class="alert alert-<?php echo strpos($message, 'Error') !== false ? 'danger' : 'success'; ?>">
                    <?php echo htmlspecialchars($message); ?>
                </div>
            <?php endif; ?>

            <div class="card">
                <div class="card-header">Payment Form</div>
                <div class="card-body">
                    <form action="payments.php" method="post">
                        <div class="form-group">
                            <label for="member_id">Member ID:</label>
                            <input type="number" id="member_id" name="member_id" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label for="amount">Amount:</label>
                            <input type="number" id="amount" name="amount" class="form-control" step="0.01" required>
                        </div>
                        <div class="form-group">
                            <label for="payment_date">Date:</label>
                            <input type="date" id="payment_date" name="payment_date" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label for="notes">Notes:</label>
                            <textarea id="notes" name="notes" class="form-control"></textarea>
                        </div>
                        <button type="submit" name="submit_payment" class="btn btn-primary">Record Payment</button>
                    </form>
                </div>
            </div>
        </main>
    </div>
</div>
<?php require_once 'includes/footer.php'; ?>