<?php
require_once 'includes/functions.php';
require_once 'includes/db_config.php';
session_start();

// Redirect if not logged in
if (!is_logged_in()) {
    redirect("login.php");
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['announcement_id'])) {
    $announcement_id = intval($_POST['announcement_id']);
    $user_id = $_SESSION['user_id'];

    // Check if the announcement belongs to the current user
    $sql = "SELECT user_id FROM announcements WHERE id = ?";
    $stmt = mysqli_prepare($link, $sql);
    mysqli_stmt_bind_param($stmt, "i", $announcement_id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $author_id);
    mysqli_stmt_fetch($stmt);
    mysqli_stmt_close($stmt);

    if ($author_id === $user_id) {
        // Delete the announcement
        $delete_sql = "DELETE FROM announcements WHERE id = ?";
        if ($delete_stmt = mysqli_prepare($link, $delete_sql)) {
            mysqli_stmt_bind_param($delete_stmt, "i", $announcement_id);
            mysqli_stmt_execute($delete_stmt);
            mysqli_stmt_close($delete_stmt);
            $_SESSION['message'] = "Message deleted successfully!";
        } else {
            $_SESSION['message'] = "Error: Could not delete the message.";
        }
    } else {
        $_SESSION['message'] = "You do not have permission to delete this message.";
    }
}

redirect("announcements.php");
?>