<?php
header("Content-Type: application/json");
require_once 'db_config.php';

$response = [
    'status' => 'error',
    'message' => 'An unknown error occurred.',
    'data' => null
];

try {
    // Connect to the database
    $conn = new mysqli(DB_SERVER, DB_USERNAME, DB_PASSWORD, DB_NAME);

    // Check connection
    if ($conn->connect_error) {
        throw new Exception("Connection failed: " . $conn->connect_error);
    }

    // Get total paid all time
    $total_paid_query = "SELECT SUM(amount_paid) AS total_paid FROM financial_transactions";
    $total_paid_result = $conn->query($total_paid_query);
    $total_paid_row = $total_paid_result->fetch_assoc();
    $total_paid = $total_paid_row['total_paid'] ?? 0;

    // Get payments this month
    $this_month_query = "SELECT SUM(amount_paid) AS payments_this_month FROM financial_transactions WHERE MONTH(payment_date) = MONTH(CURRENT_DATE()) AND YEAR(payment_date) = YEAR(CURRENT_DATE())";
    $this_month_result = $conn->query($this_month_query);
    $this_month_row = $this_month_result->fetch_assoc();
    $payments_this_month = $this_month_row['payments_this_month'] ?? 0;

    // Get outstanding debtors
    $debtors_query = "SELECT COUNT(DISTINCT member_id) AS outstanding_debtors FROM financial_transactions WHERE payment_status = 'pending'";
    $debtors_result = $conn->query($debtors_query);
    $debtors_row = $debtors_result->fetch_assoc();
    $outstanding_debtors = $debtors_row['outstanding_debtors'] ?? 0;

    $response['status'] = 'success';
    $response['message'] = 'Financial totals fetched successfully.';
    $response['data'] = [
        'totalPaidAllTime' => $total_paid,
        'paymentsThisMonth' => $payments_this_month,
        'outstandingDebtors' => $outstanding_debtors
    ];

    $conn->close();

} catch (Exception $e) {
    $response['message'] = 'Database error: ' . $e->getMessage();
}

echo json_encode($response);
?>
