<?php
require_once 'includes/functions.php';
require_once 'includes/db_config.php';

// Initialize session and check access
initialize_session();
if (!is_logged_in() || !user_has_permission($link, 'view_settings')) {
    error_log("Access denied to admin_settings.php. Role: " . ($_SESSION['user_role'] ?? 'none') . ", Permissions: " . json_encode(get_role_permissions($link, $_SESSION['user_role'] ?? '')));
    redirect("admin_dashboard.php");
}

// Generate CSRF token
if (!isset($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

$system_name = get_setting('system_name', $link) ?? 'Club Portal';
$message = '';
$error = '';
$message_type = '';

// Handle form submissions
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['csrf_token']) && hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
    if (isset($_POST['update_general_settings'])) {
        $system_name = sanitize_input($_POST['system_name'] ?? '');
        $currency_symbol = sanitize_input($_POST['currency_symbol'] ?? '');
        $header_text = sanitize_input($_POST['header_text'] ?? '');
        $footer_text = sanitize_input($_POST['footer_text'] ?? '');
        $account_name = sanitize_input($_POST['account_name'] ?? '');
        $bank_name = sanitize_input($_POST['bank_name'] ?? '');
        $account_number = sanitize_input($_POST['account_number'] ?? '');
        $logo_path = get_setting('system_logo', $link) ?? 'assets/images/default_logo.png';

        // Handle logo upload
        if (isset($_FILES['system_logo']) && $_FILES['system_logo']['error'] == 0) {
            $target_dir = "Uploads/";
            if (!is_dir($target_dir)) {
                mkdir($target_dir, 0755, true);
            }
            $logo_filename = basename($_FILES["system_logo"]["name"]);
            $target_file = $target_dir . uniqid() . '_' . $logo_filename;
            $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

            $check = getimagesize($_FILES["system_logo"]["tmp_name"]);
            if ($check !== false && in_array($imageFileType, ['jpg', 'jpeg', 'png', 'gif'])) {
                if (move_uploaded_file($_FILES["system_logo"]["tmp_name"], $target_file)) {
                    $logo_path = $target_file;
                } else {
                    $error .= "Error uploading logo. ";
                }
            } else {
                $error .= "Invalid image file. ";
            }
        }

        if (empty($error)) {
            // Update settings in database
            update_setting($link, 'system_name', $system_name);
            update_setting($link, 'currency_symbol', $currency_symbol);
            update_setting($link, 'system_logo', $logo_path);
            update_setting($link, 'header_text', $header_text);
            update_setting($link, 'footer_text', $footer_text);
            update_setting($link, 'account_name', $account_name);
            update_setting($link, 'bank_name', $bank_name);
            update_setting($link, 'account_number', $account_number);

            $message = "General settings updated successfully!";
            $message_type = 'success';
        } else {
            $message = $error;
            $message_type = 'danger';
        }
        // Regenerate CSRF token
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    }
} elseif ($_SERVER["REQUEST_METHOD"] == "POST") {
    $message = "Invalid CSRF token.";
    $message_type = 'danger';
    error_log("CSRF token validation failed in admin_settings.php");
}

// Fetch current settings
$system_name = get_setting('system_name', $link) ?? 'Club Portal';
$currency_symbol = get_setting('currency_symbol', $link) ?? '₦';
$header_text = get_setting('header_text', $link) ?? 'Club Management Portal';
$footer_text = get_setting('footer_text', $link) ?? '© 2025 Club Portal';
$system_logo = get_setting('system_logo', $link) ?? 'assets/images/default_logo.png';
$account_name = get_setting('account_name', $link) ?? '';
$bank_name = get_setting('bank_name', $link) ?? '';
$account_number = get_setting('account_number', $link) ?? '';
?>

<?php require_once 'includes/header.php'; ?>
<script>
document.title = 'Admin Settings - <?php echo htmlspecialchars($system_name); ?>';
</script>

<div class="container-fluid">
    <div class="row">
        <?php require_once 'includes/sidebar.php'; ?>
        <main class="col-md-9 col-lg-10 main-content">
            <h2>Admin Settings</h2>

            <?php if ($message): ?>
                <div class="alert alert-<?php echo htmlspecialchars($message_type); ?>">
                    <?php echo htmlspecialchars($message); ?>
                </div>
            <?php endif; ?>

            <div class="card mb-4">
                <div class="card-header">General Settings</div>
                <div class="card-body">
                    <form action="admin_settings.php" method="post" enctype="multipart/form-data">
                        <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($_SESSION['csrf_token']); ?>">
                        <div class="form-group mb-3">
                            <label for="system_name">System Name</label>
                            <input type="text" class="form-control" id="system_name" name="system_name" value="<?php echo htmlspecialchars($system_name); ?>">
                        </div>
                        <div class="form-group mb-3">
                            <label for="currency_symbol">Currency Symbol</label>
                            <input type="text" class="form-control" id="currency_symbol" name="currency_symbol" value="<?php echo htmlspecialchars($currency_symbol); ?>">
                        </div>
                        <div class="form-group mb-3">
                            <label for="system_logo">System Logo</label>
                            <input type="file" class="form-control-file" id="system_logo" name="system_logo" accept="image/*">
                            <small>Current logo: <img src="<?php echo htmlspecialchars($system_logo); ?>" alt="Current Logo" style="max-width: 100px;"></small>
                        </div>
                        <div class="form-group mb-3">
                            <label for="header_text">Header Text</label>
                            <input type="text" class="form-control" id="header_text" name="header_text" value="<?php echo htmlspecialchars($header_text); ?>">
                        </div>
                        <div class="form-group mb-3">
                            <label for="footer_text">Footer Text</label>
                            <input type="text" class="form-control" id="footer_text" name="footer_text" value="<?php echo htmlspecialchars($footer_text); ?>">
                        </div>
                        <h5>Payment Details</h5>
                        <div class="form-group mb-3">
                            <label for="account_name">Account Name</label>
                            <input type="text" class="form-control" id="account_name" name="account_name" value="<?php echo htmlspecialchars($account_name); ?>">
                        </div>
                        <div class="form-group mb-3">
                            <label for="bank_name">Bank Name</label>
                            <input type="text" class="form-control" id="bank_name" name="bank_name" value="<?php echo htmlspecialchars($bank_name); ?>">
                        </div>
                        <div class="form-group mb-3">
                            <label for="account_number">Account Number</label>
                            <input type="text" class="form-control" id="account_number" name="account_number" value="<?php echo htmlspecialchars($account_number); ?>">
                        </div>
                        <button type="submit" name="update_general_settings" class="btn btn-primary">Update Settings</button>
                    </form>
                </div>
            </div>
        </main>
    </div>
</div>
<?php require_once 'includes/footer.php'; ?>